% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CT_Probability_Plot}
\alias{CT_Probability_Plot}
\title{Probability Plot for the Concordance Coefficient and the Kruskal-Wallis Statistic}
\usage{
CT_Probability_Plot(C_freq = NULL, H_freq = NULL)
}
\arguments{
\item{C_freq}{Probability distribution of the Concordance coefficient obtained with the function \code{\link{CT_Distribution}}.}

\item{H_freq}{Probability distribution of the Kruskal-Wallis statistic obtained with the function \code{\link{CT_Distribution}}.}
}
\description{
This function performs the graphical visualization of the probability distribution of the Concordance coefficient and the Kruskal-Wallis statistic.
}
\examples{
Sample_Sizes <- c(5,5,5)
Distributions <-  CT_Distribution(Sample_Sizes, Num_Sim = 1000, H = 1)
C_freq <- Distributions$C_freq
H_freq <- Distributions$H_freq
CT_Probability_Plot(C_freq)
CT_Probability_Plot(C_freq, H_freq)
}
