% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutAD.R
\name{permutAD}
\alias{permutAD}
\title{Generate data with permutation-based approach accounting for auto-dependence}
\usage{
permutAD(vec, nBloks = 10)
}
\arguments{
\item{vec}{Time series vector}

\item{nBloks}{positive integer indicating the number of segements/blocks (default 10)}
}
\value{
Time series vector with exactly the same relative frequency and a similar auto-dependence as the original vector
}
\description{
This function generates a new time serie with exactly the same relative frequency as the original one,
and a similar auto-dependence by cutting the original variable in segments and shuffeling these segements.
}
\examples{
ts=rep(c(1,1,1,1,1,0,0,0),15)
permutAD(ts,nBloks=11)
}
