% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conProf.R
\name{conProf}
\alias{conProf}
\title{Compare different lags in a contingency profile}
\usage{
conProf(data, maxlag, conFun)
}
\arguments{
\item{data}{Binary time-points-by-variable matrix}

\item{maxlag}{Positive integer indicating how many lags should be investigated}

\item{conFun}{Contingency measure function (calculating the contingency value between two binary vectors).
Built in: funPropAgree, funClassJacc, funKappa, funCorrJacc, funOdds, funLogOdds, funPhiCC}
}
\value{
A conProf-object consisting of

\code{value} Contingency matrices for different lags

\code{para}  Parameters including \code{maxlag}, \code{funName} and \code{varNames}
}
\description{
Compare different lags in a contingency profile
}
\examples{
 IntData <- cbind(rep(rep(c(0,0,1,0,1,0,1,0,0,0),each=5),times=5),
                            rep(rep(c(1,0,0,0), each=10), times=25))
           colnames(IntData) <- c('Var1','Var2')
           conProf(IntData,maxlag=10,conFun=funClassJacc)


}
