% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfp_layered_profile.R
\name{cfp_layered_profile}
\alias{cfp_layered_profile}
\title{Object for layered soil profiles}
\usage{
cfp_layered_profile(x, id_cols = NULL)
}
\arguments{
\item{x}{A \code{data.frame} with columns \code{upper} and \code{lower}.}

\item{id_cols}{Column names in data.frame that uniquely identify each
profile.}
}
\value{
A \code{cfp_layered_profile} object. This is a
[cfp_profile()] that is further subdivided into layers by the
columns \code{upper} and \code{lower}.
}
\description{
A subclass of \code{\link{cfp_profile}()} where each profile consists of
layers that are defined by their \code{upper} and \code{lower}
boundary without gaps or duplicates.
}
\details{
\code{upper} and \code{lower} define the upper and lower bounds of
each layer in cm. Higher values lay on top of lower values.
}
\examples{
df <- data.frame(
  site = rep(c("site_a", "site_b"), each = 2),
  upper = c(10, 0, 7, 0),
  lower = c(0, -100, 0, -100),
  variable = 1:4)

cfp_layered_profile(df, id_cols = "site")
}
\seealso{
Other data formats: 
\code{\link{cfp_dat}()},
\code{\link{cfp_gasdata}()},
\code{\link{cfp_layers_map}()},
\code{\link{cfp_profile}()},
\code{\link{cfp_soilphys}()}
}
\concept{data formats}
