% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadCurrentDdl.R
\name{downloadCurrentDdl}
\alias{downloadCurrentDdl}
\title{Get current DDL sitting on the main branch}
\usage{
downloadCurrentDdl(
  githubPath = "OHDSI/CommonDataModel",
  pathToCsv = "Sql\%20Server/OMOP\%20CDM\%20sql\%20server\%20ddl.txt",
  outputFile = paste0("inst/sql/sql_server/OMOP CDM ddl ", Sys.Date(), ".sql")
)
}
\arguments{
\item{githubPath}{The path for the GitHub repo containing the package (e.g. 'OHDSI/CommonDataModel').}

\item{pathToCsv}{The path for the snapshot inside the package.}

\item{outputFile}{The path where the file should be saved.}
}
\value{
The current DDL sitting on the main branch of the CommonDataModel repository.
}
\description{
Get current DDL sitting on the main branch
}
\details{
This function gets the current ddl on the CDM main branch. It will be taken from the Sql Server folder.
The default location is
\code{inst/settings/currentOmopDdl.sql}.
}
\examples{
\dontrun{
downloadCurrentDdl("OHDSI/CommonDataModel",
 pathToCsv="Sql\%20Server/OMOP\%20CDM\%20sql\%20server\%20ddl.txt")
}
}
