% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMDU.R
\name{BMDU}
\alias{BMDU}
\title{BMDU: Multinomial–Dirichlet Unequal Prior Bayesian Method}
\usage{
BMDU(x, d)
}
\arguments{
\item{x}{Integer vector of observed counts. Must be non-negative.}

\item{d}{Integer scalar controlling how the categories are divided into
two groups for constructing unequal Dirichlet priors.}
}
\value{
Prints posterior means, lower and upper 95% credible limits for each category,
and the product of the interval widths (volume).
}
\description{
Computes the Bayesian Dirichlet posterior for a multinomial vector
using unequal prior parameters. The prior is constructed by dividing
the categories into two groups, assigning random priors from different ranges
to simulate unequal information across categories.
}
\examples{
y <- c(44, 55, 43, 32, 67, 78)
z <- 2
BMDU(y, z)

}
