% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaPrep.R
\name{ctmaPrep}
\alias{ctmaPrep}
\title{ctmaPrep}
\usage{
ctmaPrep(
  selectedStudies = NULL,
  excludedElements = NULL,
  addElements = NULL,
  digits = 4,
  moderatorLabels = NULL,
  moderatorValues = NULL,
  newRawDataDirectory = NULL,
  n.latent = NULL,
  summary = TRUE,
  activeDirectory = NULL,
  ctmaPrepObject = NULL,
  excludedStudies = NULL
)
}
\arguments{
\item{selectedStudies}{Vector of primary study numbers (numeric values with no leading 0; e.g., '2' but not '02')}

\item{excludedElements}{Vector of predefined objects used to code primary study information. Some predefined objects are strongly
defined; they have to be used in a special way because they are actually used in subsequent analyses. Some other objects could be
used at the researcher's convenience (information is just collected). Strongly predefined objects are 'delta_t' (vector of time
intervals; the only mandatory requirement; should be of the type c(NA, NA) in cases when raw data are provided), 'sampleSize'
(single number), 'pairwiseN' (matrix of pairwise N; could be used if correlation matrix is based on pairwise N), 'empcov' (correlation
matrix), 'moderator' (vector of numbers; could be continuous or categorical), 'startValues' (vector of start values), 'rawData'
(information about file name and structure of raw data), 'empMeans' (means for variables; usually 0), and 'empVars' (varainces for
variables; usually 1). Weakly predefined objects are 'studyNumber' (intended as a special number used for the outputs of subsequently
fitted CoTiMA models), 'source' (intended as vector of authors' names and publication year), 'ageM' (intended as value indicating the
mean age of participants in a primary study), 'malePercent' (intended as value indicating the percentage of male participants in a
primary study), 'occupation' (intended as vector of character strings representing the occupations of participants in a primary study),
'country' (intended as single character string representing the country in which a primary study was conducted), 'alphas' (intended as
vector of Cronbach's alphas of the variables of a primary study; not yet functional), and 'targetVariables' (intended as vector of
character strings representing information about the variables used).'}

\item{addElements}{User-added objects that are handled as the weakly predefined objects. The major purpose is to collect information
a researcher regards as important.}

\item{digits}{Rounding used for summary function}

\item{moderatorLabels}{character vector of names}

\item{moderatorValues}{list of character vectors}

\item{newRawDataDirectory}{(NULL = default) Change paths for all raw data files.}

\item{n.latent}{(NULL = default) Only required for summary and if rawData are provided}

\item{summary}{if TRUE (default) creates summary table and xlsx sheets. Could be set to FALSE in case of errors.}

\item{activeDirectory}{Mandatory. If subsequent fitting is done using different folders or on different computers, it can be}

\item{ctmaPrepObject}{previously created object with ctmaPrep, from which studies should be excluded. Only works in combination with the argument excludeStudies.}

\item{excludedStudies}{studies to be excluded from a previously created ctmaPrep-object
changed so that raw data files can be loaded.}
}
\value{
List of primary studies and parameters for the following CoTiMA (plus StudyInformation which could be saved to Excel)
}
\description{
Combines information of primary studies into a list object and returns this list. This list is then used as input to
fit 'ctsem' models. Primary study information is expected to be assigned to 'numbered' objects. Some of these objects are pre-defined
(e.g., 'empcov', 'ageM'). Most of the pre-defined objects could be empty, or they could be dropped by entering their names in the
excludedElements-object (e.g., excludedElements = c('ageM')), but dropping them is not really necessary. Additional elements could
also be added, which could be useful to put together all information about primary studies at the convenience of the researcher.
}
\note{
The following example shows information a researcher has about three studies, which have the numbers '2', '4' and '17'.
All information about these studies are stored in objects ending with '2', '4', and '17', respectively. In most instances, one
relevant piece of information is the empirical correlation (or covariance) matrix reported in this study, which is stored in the
objects 'empcov2', 'empcov4', and 'empcov17'. Note that full and symmetric matrices are required for ctmaPrep. Usually, sample
sizes ('sampleSize2', 'sampleSize4', & 'sampleSize17') and time lags ('delta_t2', 'delta_t4', & 'delta_t17'), are required, too.
}
\examples{
# First Study
empcov2 <- matrix(c(1.00, 0.45, 0.57, 0.18,
                    0.45, 1.00, 0.31, 0.66,
                    0.57, 0.31, 1.00, 0.40,
                    0.18, 0.66, 0.40, 1.00), nrow=4, ncol=4)
delta_t2 <- 12
sampleSize2 <- 148
moderator2 <- c(1, 0.72)
source2 <- c("Houkes, I,", "Janssen, P, P, M,", "de Jonge, J",
              "& Bakker, A, B", "Study1", "2003")
addedByResearcher2 <- "something you want to add"

# Second Study
empcov3 <- matrix(c(1.00, 0.43, 0.71, 0.37,
                    0.43, 1.00, 0.34, 0.69,
                    0.71, 0.34, 1.00, 0.50,
                    0.37, 0.69, 0.50, 1.00), nrow=4, ncol=4)
delta_t3 <- 12
sampleSize3 <- 88
moderator3 <- c(1, 0.72)
source3 <- c("Houkes, I,", "Janssen, P, P, M,", "de Jonge, J",
              "& Bakker, A, B", "Study2", "2003")
addedByResearcher3 <- ""

# Third Study
empcov313 <- matrix(c(1.00, 0.38, 0.54, 0.34, 0.60, 0.28,
                      0.38, 1.00, 0.34, 0.68, 0.28, 0.68,
                      0.54, 0.34, 1.00, 0.47, 0.66, 0.39,
                      0.34, 0.68, 0.47, 1.00, 0.38, 0.72,
                      0.60, 0.28, 0.66, 0.38, 1.00, 0.38,
                      0.28, 0.68, 0.39, 0.72, 0.38, 1.00), nrow=6, ncol=6)
delta_t313 <- c(1.5, 1.5)
sampleSize313 <- 335
moderator313 <- c(0.8,	2.47)
source313 <- c("Demerouti", "Bakker", "& Bulters", "2004")
addedByResearcher313 <- "check correlation matrix"

# Add Labels and Values for Moderators (just for optional excel tables)
moderatorLabels <- c("Control", "Social Support")
moderatorValues <- list("continuous", c("1 = very low", "2 = low",
                       "3 = medium", "4 = high", "5 = very high"))

CoTiMAstudyList_3 <- ctmaPrep(selectedStudies = c(2, 3, 313),
                              activeDirectory="/user/",
                              excludedElements = "ageM",
                              addElements = "addedByResearcher",
                              moderatorLabels=moderatorLabels,
                              moderatorValues=moderatorValues)

}
