% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNI_functions.R
\name{find_localControllingFeatures}
\alias{find_localControllingFeatures}
\title{Find local controlling features}
\usage{
find_localControllingFeatures(ResultsCoNI, network, padjust = TRUE)
}
\arguments{
\item{ResultsCoNI}{The output of CoNI (after p-adjustment)}

\item{network}{Network created with the function generate_network}

\item{padjust}{logical. Filter output based on adjusted p values}
}
\value{
Returns a data.frame with the results of the binomial tests. Significant results correspond to local controlling features
}
\description{
This function applies for a selected subnetwork a binomial test using the frequency of appearance of an edge feature and the total number of edge features. The probability corresponds to 1/n_df, where n_df corresponds to the total number of edge features in the network.
The selected subnetwork corresponds to the second level neighborhood of a specific node. The test is applied to all possible second level neighborhoods in the network.
}
\examples{
#Load color nodes table
data(MetColorTable)

#Assign colors according to "Class" column
MetColorTable<-assign_colorsAnnotation(MetColorTable)

#Load CoNI results
data(CoNIResultsHFDToy)

#Generate Network
#Note: Colors not visible when ploting in Igraph
HFDNetwork<-generate_network(ResultsCoNI = CoNIResultsHFDToy,
                             colorVertexNetwork = TRUE,
                             colorVertexTable = MetColorTable,
                             Class = MetColorTable,
                             outputDir = "./",
                             outputFileName = "HFD",
                             saveFiles = FALSE)

#Note: For this tiny example nothing is significant
LCG_BinomialTestTableHFD<- find_localControllingFeatures(ResultsCoNI = CoNIResultsHFDToy,
                                                         network = HFDNetwork )
LCGenes_HFD<-as.character(unique(LCG_BinomialTestTableHFD$edgeFeatures))

}
