% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridgeregression.R
\name{ridgeregression}
\alias{ridgeregression}
\title{Ridge regression}
\usage{
ridgeregression(Tt, especie, E, EspecieMaxima, seed = NULL)
}
\arguments{
\item{Tt}{Number of time points available}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points. The bacteria placed in the last row of the matrix will be used as reference in the alr transformation and will be at the denominator of the balance.}

\item{E}{Number of bacteria available.}

\item{EspecieMaxima}{Row in which the bacteria used as reference is in \code{especie}. This is the bacteria that is going to be at the denominator of the balance and the denominator of the alr transformation. As a result, in this function, \code{EspecieMaxima} must be equal to \code{E}}

\item{seed}{Number. Set a seed. Default \code{seed=NULL}.}
}
\value{
Returns the result of the ridge regression, object of class "ridgelm".
}
\description{
Ridge regression
}
\examples{


set.seed(123)
especie=t(gtools::rdirichlet(10,c(1,3,1,2,4)))
Tt=10
E=5
EspecieMaxima=5

ridgeregression(Tt,especie, E, EspecieMaxima, 558562316)


}
