% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table_alr_Dirich_glv.R
\name{Table_alr_Dirich_glv}
\alias{Table_alr_Dirich_glv}
\title{Obtainig a table with the interpretable parameters}
\usage{
Table_alr_Dirich_glv(Param.Estimates, especie, names, E)
}
\arguments{
\item{Param.Estimates}{Vector with the estimates parameters. It is equal to \code{c(tau,as.vector( pam))} where:

\itemize{
  \item pam  Matrix. Each row has the parameters of each bacteria. Following our example, pam has the parameters placed as follows:
  \tabular{rrrr}{
 r1 \tab  a11  \tab  a12\cr
 r2 \tab  a21 \tab   a22 }
  \item tau  Number. Value of the tau parameter in the model
  }}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points. The bacteria placed in the last row of this matrix is the one used as reference in the alr transformation that the model applies.}

\item{names}{Vector with the name of the bacteria in the same order than are present in the \code{especie} matrix.}

\item{E}{Number of bacteria available.}
}
\value{
Returns the table as formatted text. By using the \code{cat} function, you can generate a LaTeX-ready table that can be easily copied and pasted.
}
\description{
This function returns a table with the interpretable parameters of the Dirich-gLV model.
}
\details{
In an example with three bacteria, the regression of this model is defined by

\deqn{r_{1}\cdot log(x_{1}(t)/x_{3}(t))+log(x_{1}(t)/x_{3}(t))\cdot [a_{11}\cdot log(x_{1}(t)/x_{3}(t))(t)+a_{12}\cdot log(x_{2}(t)/x_{3}(t))] }
\deqn{r_{2}\cdot log(x_{2}(t)/x_{3}(t))+log(x_{2}(t)/x_{3}(t))\cdot [a_{21}\cdot log(x_{1}(t)/x_{3}(t))(t)+a_{22}\cdot log(x_{2}(t)/x_{3}(t))] }
}
\examples{


pam.ini=rbind(c(0.1,0.2,0.3),c(0.4,0.5,0.6))
paramEstimadosFinal=c(5, as.vector(pam.ini))
E=3
especie=cbind(c(0.2,0.4,0.4),c(0.1,0.1,0.8),c(0.5,0.1,0.4))
names=c("a","b","c")

tat=Table_alr_Dirich_glv(paramEstimadosFinal,especie,names,E)
cat(tat, sep = "\n")

}
\references{
Creus-Martí, I. and Moya, A. and Santonja, F. J. (2018). A Statistical Model with a Lotka-Volterra Structure for Microbiota Data. Lucas Jodar, Juan Carlos Cortes and Luis Acedo,  Modelling or engineering and human behavior 2018, Instituto Universitario de Matematica Multidisciplinar. ISBN: 978-84-09-07541-6
}
