% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusbootglm.R
\name{clusbootglm}
\alias{clusbootglm}
\title{Fit generalized linear models with the cluster bootstrap}
\usage{
clusbootglm(
  model,
  data,
  clusterid,
  family = gaussian,
  B = 5000,
  confint.level = 0.95,
  n.cores = 1
)
}
\arguments{
\item{model}{generalized linear model to be fitted with the cluster bootstrap. This should either be a formula (or be able to be interpreted as one) or a \code{glm} / \code{lm} object. From the \code{(g)lm} objects, the formula will be used.}

\item{data}{dataframe that contains the data.}

\item{clusterid}{variable in data that identifies the clusters.}

\item{family}{error distribution to be used in the model, e.g. \code{gaussian} or \code{binomial}.}

\item{B}{number of bootstrap samples.}

\item{confint.level}{level of confidence interval.}

\item{n.cores}{number of CPU cores to be used.}
}
\value{
\code{clusbootglm} produces an object of class \code{"clusbootglm"}, containing the following relevant components:
\item{coefficients}{A matrix of \code{B} rows, containing the parameter estimates for all bootstrap samples.}
\item{bootstrap.matrix}{n*B matrix, of which each column represents a bootstrap sample; each value in a column represents 
                        a unit of \code{subjectid}.}
\item{lm.coefs}{Parameter estimates from a single (generalized) linear model.}
\item{boot.coefs}{Mean values of the paramater estimates, derived from the bootstrap coefficients.}
\item{boot.sds}{Standard deviations of cluster bootstrap parameter estimates.}
\item{ci.level}{User defined confidence interval level.}
\item{percentile.interval}{Confidence interval based on percentiles, given the user defined confidence interval level.}
\item{parametric.interval}{Confidence interval based on \code{lm.coefs} and column standard deviations of \code{coefficients}, 
                           given the user defined confidence interval level.}
\item{BCa.interval}{Confidence interval based on percentiles with bias correction and acceleration, given the user defined 
                    confidence interval level.}
\item{samples.with.NA.coef}{Cluster bootstrap sample numbers with at least one coefficient being \code{NA}.}
\item{failed.bootstrap.samples}{For each of the coefficients, the number of failed bootstrap samples are given.}
}
\description{
Fit a generalized linear model with the cluster bootstrap for analysis of clustered data.
}
\details{
Some useful methods for the obtained \code{clusbootglm} class object are \code{\link{summary.clusbootglm}}, 
         \code{\link{coef.clusbootglm}}, and \code{\link{clusbootsample}}.
}
\examples{
\dontrun{
data(opposites)
clusbootglm(SCORE~Time*COG,data=opposites,clusterid=Subject)}
}
\author{
Mathijs Deen, Mark de Rooij
}
