% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_FreeSort.R
\name{preprocess_FreeSort}
\alias{preprocess_FreeSort}
\title{Preprocessing for Free Sorting Data}
\usage{
preprocess_FreeSort(Data, NameSub=NULL)
}
\arguments{
\item{Data}{data frame or matrix. Corresponds to all variables that contain subjects results. Each column corresponds to a subject and gives the groups to which the products (rows) are assigned}

\item{NameSub}{string vector. Name of each subject. Length must be equal to the number of clumn of the Data. If NULL, the names are S1,...Sm. Default: NULL}
}
\value{
A list with:
        \itemize{
         \item new_Data: the Data transformed
         \item Blocks: the number of groups for each subject
         \item NameBlocks: the name of each subject
         }
}
\description{
For Free Sorting Data, this preprocessing is needed.
}
\examples{
data(choc)
prepro=preprocess_FreeSort(choc)

}
\references{
Llobell, F., Cariou, V., Vigneau, E., Labenne, A., & Qannari, E. M. (2018). Analysis and clustering of multiblock datasets by means of the STATIS and CLUSTATIS methods. Application to sensometrics. Food Quality and Preference, in Press.
}
\seealso{
\code{\link{clustatis}}, \code{\link{clustatis_FreeSort}}
}
\keyword{FreeSorting}
