% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ang.pdist.R
\name{ang.pdist}
\alias{ang.pdist}
\title{Pairwise L2 angular distance}
\usage{
ang.pdist(data)
}
\arguments{
\item{data}{n x d angular data on \eqn{[0, 2\pi)^d}}
}
\value{
\code{ang.pdist} returns pairwise angular distances matrix
  with the class \code{dist}
}
\description{
\code{ang.pdist} computes pairwise angular distances matrix.
}
\examples{
data <- matrix(c(pi/3, pi/3, pi/2,
                 pi, pi/4, pi/2,
                 0, pi/3, pi/6),
               ncol = 3, byrow = TRUE)

ang.pdist(data)
}
\references{
Jung, S., Park, K., & Kim, B. (2021). Clustering on the torus by conformal prediction. The Annals of Applied Statistics, 15(4), 1583-1603.
}
\seealso{
\code{\link{ang.dist}}, \code{\link[stats]{dist}}
}
