% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObsTime.TwoArm.R
\name{ObsTime.TwoArm}
\alias{ObsTime.TwoArm}
\title{Calculate the observation time for a two-arm clinical trial}
\usage{
ObsTime.TwoArm(
  N.0 = NULL,
  N.1 = NULL,
  ratio = NULL,
  d = NULL,
  gamma.c = NULL,
  alpha0.t = NULL,
  nu0.t,
  alpha1.t,
  nu1.t,
  s,
  m,
  design2 = NULL
)
}
\arguments{
\item{N.0}{number of subjects plan to be enrolled in control arm}

\item{N.1}{number of subjects plan to be enrolled in experimental arm}

\item{ratio}{randomization ratio between two arms: \code{N.1} / \code{N.0}}

\item{d}{expected number of events observed at time \code{l}}

\item{gamma.c}{parameter of the exponential distribution of censoring time}

\item{alpha0.t}{shape parameter of weibull survival distribution for control arm}

\item{nu0.t}{scale parameter of weibull survival distribution for control arm}

\item{alpha1.t}{shape parameters of weibull survival distribution for experimental arm}

\item{nu1.t}{scale parameter of a weibull survival distribution for control arm}

\item{s}{enrollment time}

\item{m}{maximum follow-up time for a subject}

\item{design2}{a list containing all the above parameters for two-arm design}
}
\value{
This function returns a list containing all design parameters, including the calculated observation time \code{l}
}
\description{
predicting two-arm clinical trial
}
\examples{
# calculate the observation time
ObsTime.TwoArm(N.0=100,N.1=100,d=10,gamma.c=1,alpha0.t = 1,nu0.t=5,alpha1.t=2,nu1.t=4,s=5,m=4)

}
