% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObsTime.OneArm.R
\name{ObsTime.OneArm}
\alias{ObsTime.OneArm}
\title{Calculate the observation time for a one-arm clinical trial}
\usage{
ObsTime.OneArm(
  N = NULL,
  d = NULL,
  s = NULL,
  m = NULL,
  alpha = NULL,
  nu = NULL,
  gamma = NULL
)
}
\arguments{
\item{N}{Number of subjects plan to enrolled}

\item{d}{expected number of events observed at time \code{l}}

\item{s}{enrollment period}

\item{m}{maximum follow-up for a single subject}

\item{alpha}{shape parameter of weibull survival distribution}

\item{nu}{scale parameter of weibull survival distribution}

\item{gamma}{parameter of the exponential distribution of censoring time}
}
\value{
This function returns a list containing all design parameters, including the calculated observation time \code{l}.
}
\description{
Calculate the observation time for a one-arm clinical trial
}
\examples{
ObsTime.OneArm(N=100,d=10,gamma=0.1,s=12,m=6,alpha=1,nu=20)
}
