% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv18_ewma.R
\name{cv18_ewma}
\alias{cv18_ewma}
\title{Exponentially Weighted Moving Average (EWMA) Chart}
\usage{
cv18_ewma(data, residue_col, cleaning_event_col, alpha = 0.2)
}
\arguments{
\item{data}{A data frame containing the data set for analysis.}

\item{residue_col}{The name of the column representing residue data.}

\item{cleaning_event_col}{The name of the column representing cleaning events.}

\item{alpha}{The smoothing parameter for the EWMA calculation, default is 0.2.}
}
\value{
A ggplot object representing the EWMA chart.
}
\description{
Generates an EWMA chart for a specified residue column grouped by cleaning events.
}
\examples{
# Assuming 'Eq_Mic' is a data frame, 'Mic' is the residue column of interest,
# and 'CleaningEvent' is the column representing cleaning events.
ewma_plot <- cv18_ewma(data = Eq_Mic, residue_col = "Mic", cleaning_event_col = "CleaningEvent")
print(ewma_plot)
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
