% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_matrix.R
\name{trim_matrix}
\alias{trim_matrix}
\title{Trims a morphological distance matrix}
\usage{
trim_matrix(distance_matrix, tree = NULL)
}
\arguments{
\item{distance_matrix}{A distance matrix in the format created by \link{calculate_morphological_distances}.}

\item{tree}{If the distance matrix includes ancestors this should be the tree (phylo object) used to estimate their states.}
}
\value{
\item{distance_matrix}{A complete distance matrix with all cells filled. If there were no empty cells will return original.}
\item{tree}{A tree (if supplied) with the removed taxa (see below) pruned. If no taxa are dropped will return the same tree as inputted. If no tree is supplied this is set to NULL.}
\item{removed_taxa}{A character vector listing the taxa removed. If none are removed this will be set to NULL.}
}
\description{
Trims a morphological distance matrix by removing objects that cause empty cells.
}
\details{
Trims a morphological distance matrix by removing nodes (terminal or internal) that cause empty cells allowing it to be passed to an ordination function such as \link{cmdscale}.

Some distances are not calculable from cladistic matrices if there are taxa that have no coded characters in common. This algorithm iteratively removes the taxa responsible for the most empty cells until the matrix is complete (no empty cells).

If the matrix includes estimated ancestral states the user should also provide the tree used (as the \code{tree} argument). The function will then also remove the tips from the tree and where reconstructed ancestors also cause empty cells will prune the minimum number of descendants of that node. The function will then renumber the nodes in the distance matrix so they match the pruned tree.
}
\examples{

# Get morphological distances for Michaux (1989) data set:
distances <- calculate_morphological_distances(cladistic_matrix = michaux_1989)

# Attempt to trim max.distance_matrix:
trim_matrix(distance_matrix = distances$distance_matrix)
}
\seealso{
\link{calculate_morphological_distances}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
