% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_labels.r
\name{make_labels}
\alias{make_labels}
\title{Make unique text labels}
\usage{
make_labels(N)
}
\arguments{
\item{N}{The number of labels required,}
}
\value{
A character vector of N unique labels.
}
\description{
Given a requisite number, generates that many unique text labels.
}
\details{
Where a list of unique text labels are required (i.e., where simple numbering will not suffice) it can be useful to have a simple function that generates the required amount.

In practice, this is simple in R when N is 26 or less as the \code{LETTERS} object can be used for this purpose. For example, to get ten unique labels:

\code{LETTERS[1:10]}

This function works in a similar way but will add a second, third etc. letter where the value of N requires it.
}
\examples{

# Make 40 unique text labels:
make_labels(N = 40)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
