% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_bracket_positions.r
\name{locate_bracket_positions}
\alias{locate_bracket_positions}
\title{Locates matching positions for sets of brackets in a text string}
\usage{
locate_bracket_positions(input_string, bracket_type = "()")
}
\arguments{
\item{input_string}{An input string containing matching brackets, such as a Newick string or character state tree.}

\item{bracket_type}{The type of bracket to use. Must be one of parentheses \code{()}, curly braces \code{{}}, or square brackets \code{[]}.}
}
\value{
A two-column matrix indicating opening and closing bracket positions within \code{input_string}.
}
\description{
Given a text string will return the positions of each matching pair of opening and closing brackets.
}
\details{
This function is designed to deal with Newick strings and character state trees - ways of encoding information using nested parentheses. Although it is intended for internal use it seems sufficiently general to share as part of the package.

The function works by traversing the string from left to right and noting the position of each opening parenthesis and then storing the corresponding position for its' matching closing parenthesis.

It currently only works for a single string, but coud be built into a for loop or apply function if multiple strings are desired.
}
\examples{

# Locate the positions of a set of parentheses in a character state tree:
locate_bracket_positions(
  input_string = "(((5)4)3,(2)1)0",
  bracket_type = "()"
)

}
\seealso{
\link{convert_state_tree_to_adjacency_matrix}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
