% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.timeBins.R
\name{is.timeBins}
\alias{is.timeBins}
\title{Time bins class}
\usage{
is.timeBins(x)
}
\arguments{
\item{x}{A timeBins object.}
}
\value{
\code{is.timeBins} returns either TRUE or FALSE.
}
\description{
Functions to deal with the time bins class.
}
\details{
Claddis uses various classes to define specific types of data, here the use of time bins (to bin any temporal data) ae assigned the class "timeBins" and should look something like this:

\preformatted{                  fad  lad
    Cenomanian    99.6 93.5
    Turonian      93.5 89.3
    Coniacian     89.3 85.8
    Santonian     85.8 83.5
    Campanian     83.5 70.6
    Maastrichtian 70.6 65.5}

I.e., a matrix with two columns (fad = first appearance date and lad = last appearance date) with rows corresponding to named time bins and individual values ages in millions of years ago (Ma). The object should also have class \code{timeBins} (see example below for how to generate a valid object). Note also that the convention in Claddis is to have time bins be ordered from oldest to youngest.

\code{is.timeBins} checks whether an object is or is not a valid timeBins object.
}
\examples{

# Create a time bins object:
time_bins <- matrix(
  data = c(99.6, 93.5, 93.5, 89.3, 89.3, 85.8, 85.8, 83.5, 83.5, 70.6, 70.6, 65.5),
  ncol = 2,
  byrow = TRUE,
  dimnames = list(
    c("Cenomanian", "Turonian", "Coniacian", "Santonian", "Campanian", "Maastrichtian"),
    c("fad", "lad")
  )
)

# Check that this is a valid timeBins object (will fail as class is not set):
is.timeBins(x = time_bins)

# Set class as timeBins:
class(time_bins) <- "timeBins"

# Check that this is a valid timeBins object (will succeed as format and
# class are correct):
is.timeBins(x = time_bins)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
