% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc.r
\name{vpcmodel}
\alias{vpcmodel}
\title{Perform visual predictive check for NLME models}
\usage{
vpcmodel(
  model,
  vpcParams,
  params,
  hostPlatform = NULL,
  runInBackground = FALSE,
  ...
)
}
\arguments{
\item{model}{PK/PD model class object.}

\item{vpcParams}{VPC argument setup. See \code{\link{NlmeVpcParams}}.
If \code{missing}, default values generated by NlmeVpcParams() are used.}

\item{params}{Engine argument setup. See \code{\link{engineParams}}. The following
arguments are the subject of interest: sort, ODE, rtolODE, atolODE, maxStepsODE.
If \code{missing}, default values generated by engineParams(model) are used.}

\item{hostPlatform}{Host definition for model execution. See \code{\link{hostParams}}.
If \code{missing}, simple local host is used.}

\item{runInBackground}{Set to \code{TRUE} to run in background and return prompt.}

\item{...}{Additional class initializer arguments for \code{\link{NlmeVpcParams}} or
\code{\link{hostParams}}, or arguments available inside \code{\link{engineParams}} functions.
If \code{\link{engineParams}} arguments are supplied through both \code{params} argument
and additional argument (i.e., ellipsis), then the arguments in \code{params} will be ignored
and only the additional arguments will be used with warning.
If \code{\link{hostParams}} arguments are supplied through both \code{hostPlatform}
 argument and additional argument, then its values will be overridden by additional arguments.
 In addition, if \code{\link{NlmeVpcParams}} arguments are supplied through both
 \code{vpcParams} argument and additional argument,
 then its slots will be overridden by additional arguments.}
}
\value{
if runInBackground is \code{TRUE}, it returns job properties.
Otherwise, \itemize{
\item {If the function is called in an interactive mode,
the resulting  simulated tables and summary statistics tables will be loaded
and presented as a list;}
\item {If the function is called in a non-interactive mode,
it returns the full paths of the tables generated}}
}
\description{
Perform visual predictive check for NLME models
}
\examples{
\dontrun{
model <- pkmodel(
  numComp = 1,
  absorption = "Extravascular",
  ID = "Subject",
  Time = "Act_Time",
  CObs = "Conc",
  Aa = "Amount",
  data = pkData,
  modelName = "PkModel",
  workingDir = tempdir()
)

 host <- hostParams(
  sharedDirectory = tempdir(),
  parallelMethod = "NONE",
  hostName = "local",
  numCores = 1
 )

job <- fitmodel(model = model,
                hostPlatform = host)

finalModelVPC <- copyModel(model,
                           acceptAllEffects = TRUE,
                           modelName = "model_VPC",
                           workingDir = tempdir())

# View the model
print(finalModelVPC)

# Set up VPC arguments to have PRED outputted to simulation output dataset "predout.csv"
vpcSetup <- NlmeVpcParams(outputPRED = TRUE)

# Run VPC using the default host, default values for the relevant NLME engine arguments
finalVPCJob <- vpcmodel(model = finalModelVPC, vpcParams = vpcSetup, hostPlatform = host)
# the same as:
# finalVPCJob <- vpcmodel(model = finalModelVPC, outputPRED = TRUE)

# Observed dataset predcheck0.csv
dt_ObsData <- finalVPCJob$predcheck0

# Simulation output dataset predout.csv
dt_SimData <- finalVPCJob$predout

# Add PRED from REPLICATE = 0 of simulation output dataset to observed input dataset
dt_ObsData$PRED <- dt_SimData[REPLICATE == 0]$PRED

# tidyvpc package VPC example:
# library(tidyvpc)
# library(magrittr)
# Create a regular VPC plot with binning method set to be "jenks"
# binned_VPC <- observed(dt_ObsData, x = IVAR, yobs = DV) \%>\%
# simulated(dt_SimData, ysim = DV) \%>\%
# binning(bin = "jenks") \%>\%
# vpcstats()

# plot_binned_VPC <- plot(binned_VPC)

# Create a pcVPC plot with binning method set to be "jenks"
# binned_pcVPC <- observed(dt_ObsData, x = IVAR, yobs = DV) \%>\%
#   simulated(dt_SimData, ysim = DV) \%>\%
#   binning(bin = "jenks") \%>\%
#   predcorrect(pred = PRED) \%>\%
#   vpcstats()

# plot_binned_pcVPC <- plot(binned_pcVPC)
}

}
