% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkindirectmodel.R
\name{pkindirectmodel_MappingParameters}
\alias{pkindirectmodel_MappingParameters}
\title{PK Indirect model mapping parameters}
\usage{
pkindirectmodel_MappingParameters(
  ID = NULL,
  Time = NULL,
  A1 = NULL,
  Aa = NULL,
  A = NULL,
  A1_Rate = NULL,
  A1_Duration = NULL,
  Aa_Rate = NULL,
  Aa_Duration = NULL,
  A_Rate = NULL,
  A_Duration = NULL,
  A1Strip = NULL,
  CObs = NULL,
  C1Obs = NULL,
  A0Obs = NULL,
  EObs = NULL,
  nV = NULL,
  nV2 = NULL,
  nV3 = NULL,
  nCl = NULL,
  nCl2 = NULL,
  nCl3 = NULL,
  nKa = NULL,
  nA = NULL,
  nAlpha = NULL,
  nB = NULL,
  nBeta = NULL,
  nC = NULL,
  nGamma = NULL,
  nKe = NULL,
  nK12 = NULL,
  nK21 = NULL,
  nK13 = NULL,
  nK31 = NULL,
  nTlag = NULL,
  nKm = NULL,
  nVmax = NULL,
  nFe = NULL,
  nMeanDelayTime = NULL,
  nShapeParamMinusOne = NULL,
  nShapeParam = NULL
)
}
\arguments{
\item{ID}{Column mapping argument for input dataset column(s) that identify
individual data profiles. Only applicable to population models \code{isPopulation = TRUE}.}

\item{Time}{Column mapping argument that represents the input dataset column
for the relative time used in a study and only applicable to time-based models.}

\item{A1}{Column mapping argument that represents the input dataset column
for the amount of drug administered. Only applicable to the following types of models:
\itemize{
 \item Models with \code{absorption = "Intravenous"} and parameterization set
 to either \code{"Clearance"},\code{"Micro"}, or \code{"Macro"}
 \item Models with \code{absorption} set to either \code{"Gamma"}, \code{"InverseGaussian"},
 or \code{"Weibull"}
 }}

\item{Aa}{Column mapping argument that represents the input dataset column
for the amount of drug administered and only applicable to models with \code{absorption = "FirstOrder"}.}

\item{A}{Column mapping argument that represents the input dataset column
for the amount of drug administered and only applicable to models with
\code{absorption = "Intravenous"} and \code{parameterization = "Macro1"}.}

\item{A1_Rate}{Column mapping argument that represents the input dataset column
for the rate of drug administered.  Only applicable to the following types of models:
\itemize{
 \item Models with \code{absorption = "Intravenous"}, \code{infusionAllowed = TRUE}
 and parameterization set to either \code{"Clearance"},\code{"Micro"} or \code{"Macro"}
 \item Models with \code{absorption} set to either \code{"Gamma"}, \code{"InverseGaussian"},
 or \code{"Weibull"} and \code{infusionAllowed = TRUE}
 }}

\item{A1_Duration}{Column mapping argument that represents the input dataset column
for the duration of drug administered.  Only applicable to the following types of models:
\itemize{
 \item Models with \code{absorption = "Intravenous"}, \code{infusionAllowed = TRUE} with
  \code{isDuration = TRUE} and parameterization set to either \code{"Clearance"},\code{"Micro"}
  or \code{"Macro"}
 \item Models with \code{absorption} set to either \code{"Gamma"}, \code{"InverseGaussian"},
 or \code{"Weibull"} and \code{infusionAllowed = TRUE} with \code{isDuration = TRUE}
 }}

\item{Aa_Rate}{Column mapping argument that represents the input dataset column
for the rate of drug administered and only applicable to models with \code{absorption = "FirstOrder"},
\code{infusionAllowed = TRUE}.}

\item{Aa_Duration}{Column mapping argument that represents the input dataset column
for the duration of drug administered and only applicable to models with \code{absorption = "FirstOrder"},
\code{infusionAllowed = TRUE}, and \code{isDuration = TRUE}.}

\item{A_Rate}{Column mapping argument that represents the input dataset column
for the rate of drug administered and only applicable to models with \code{absorption = "Intravenous"},
\code{infusionAllowed = TRUE}, and \code{parameterization = "Macro1"}.}

\item{A_Duration}{Column mapping argument that represents the input dataset column
for the duration of drug administered and only applicable to models with \code{absorption = "Intravenous"},
\code{infusionAllowed = TRUE}, \code{isDuration = TRUE}, and \code{parameterization = "Macro1"}.}

\item{A1Strip}{Column mapping argument that represents the input dataset column
for the stripping dose and only applicable to models with \code{parameterization = "Macro"}.}

\item{CObs}{Column mapping argument that represents the input dataset column
for the observations of drug concentration in the central compartment and only applicable
to models with \code{parameterization} being either set to either \code{"Clearance"} or \code{"Micro"}.}

\item{C1Obs}{Column mapping argument that represents the input dataset column
for the observations of drug concentration in the central compartment and only applicable
to models with \code{parameterization} being either set to either \code{"Macro"} or \code{"Macro1"}.}

\item{A0Obs}{Column mapping argument that represents the input dataset column
for the observed amount of drug in the elimination compartment. (\code{hasEliminationComp = TRUE}).}

\item{EObs}{Column mapping argument that represents the input dataset column
for the observed drug effect.}

\item{nV}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nV}.}

\item{nV2}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nV2}.}

\item{nV3}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nV3}.}

\item{nCl}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nCl}.}

\item{nCl2}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nCl2}.}

\item{nCl3}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nCl3}.}

\item{nKa}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nKa}.}

\item{nA}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nA}.}

\item{nAlpha}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nAlpha}.}

\item{nB}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nB}.}

\item{nBeta}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nBeta}.}

\item{nC}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nC}.}

\item{nGamma}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nGamma}.}

\item{nKe}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nKe}.}

\item{nK12}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nK12}.}

\item{nK21}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nK21}.}

\item{nK13}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nK13}.}

\item{nK31}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nK31}.}

\item{nTlag}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nTlag}.}

\item{nKm}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nKm}.}

\item{nVmax}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nVmax}.}

\item{nFe}{If \code{isSequential = TRUE} and \code{isFractionExcreted = TRUE},
mapped to the input dataset column that lists the values for random effect \code{nFe}.}

\item{nMeanDelayTime}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nMeanDelayTime}.}

\item{nShapeParamMinusOne}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nShapeParamMinusOne}.}

\item{nShapeParam}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nShapeParam}.}
}
\description{
PK Indirect mapping parameters
}
\keyword{internal}
