% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosing.r
\name{addSteadyState}
\alias{addSteadyState}
\title{Adds Steady State extra column definition to model object}
\usage{
addSteadyState(.Object, SS, II, SSOffset = NULL)
}
\arguments{
\item{.Object}{Model object}

\item{SS}{Column mapping argument specifying corresponding "SS" column in input data set}

\item{II}{Column mapping argument specifying corresponding "II" column in input data set}

\item{SSOffset}{Optional. Column mapping argument specifying corresponding "SSOffset" column in input data set}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Use to add Steady State column definition statement to \code{model@userDefinedExtraDefs}
}
\examples{
\donttest{
pkData1 <- pkData
pkData1$SS <- 0
pkData1$II <- 0
model <- pkmodel(data = pkData1,
                 ID = "Subject",
                 Time = "Act_Time",
                 A1 = "Amount",
                 CObs = "Conc",
                 workingDir = tempdir()
                 )
model <- addSteadyState(model, SS = "SS", II = "II")
}
}
