% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addInfusion.R
\name{addInfusion}
\alias{addInfusion}
\title{Change existing dosing compartment to infusion}
\usage{
addInfusion(
  .Object,
  doseCptName,
  isDuration = FALSE,
  isSecondDose = FALSE,
  colName = NULL
)
}
\arguments{
\item{.Object}{Model object}

\item{doseCptName}{Name of the compartment to which the dose is administered}

\item{isDuration}{Set \code{TRUE} if duration is used to specify infusion information}

\item{isSecondDose}{Set \code{TRUE} if doseCptName is specified in the model through dosepoint2 statement}

\item{colName}{Name of the input data column that represents the corresponding infusion rate. If not provided, \code{colName} must be mapped through \code{colMapping()}.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Allows user to switch any dosing compartment to infusion
}
\examples{
\donttest{
 pkData1 <- pkData
 pkData1$A1_1 <- 0
 model <- pkmodel(numComp = 2,
 absorption = "Intravenous",
 ID = "Subject",
 Time = "Act_Time",
 CObs = "Conc",
 A1 = "Amount",
 data = pkData1,
 modelName = "PkModel",
 workingDir = tempdir())
 newModel <- addInfusion(model, "A1", FALSE, FALSE, "A1_1")
}

}
