% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propensity_matching.R
\name{propensity_matching}
\alias{propensity_matching}
\title{Propensity Matching}
\usage{
propensity_matching(
  data,
  f = NA,
  simple = pkg.env$simple,
  p.scores = NA,
  p.simple = pkg.env$simple,
  type = "strata",
  grp.width = 0.1,
  quant = TRUE,
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables in the model.
This should be the same data used in \code{\link[=init_params]{init_params}}.}

\item{f}{(optional) an object of class "formula" that overrides the default parameter}

\item{simple}{a boolean indicator to build default formula with interactions.
If true, interactions will be excluded. If false, interactions will be included. By
default, simple is set to false.}

\item{p.scores}{(optional) use calculated propensity scores for matching. Otherwise, propensity scores
will be automatically modeled.}

\item{p.simple}{a boolean indicator to build default formula with interactions for the propensity models.
If true, interactions will be excluded. If false, interactions will be included. By
default, simple is set to false.}

\item{type}{a string representing the type of propensity model to be used. By default, the function will stratify. Standardization with
propensity scores may also be used. The value given for \code{type} must be in \code{c("strata", "stdm")}.}

\item{grp.width}{a decimal value to specify the range to stratify the propensity scores. If option \code{quant} is set to true,
this will represent the spread of percentiles. If false, it will represent the spread of raw values of propensity
scores. Must be a decimal between 0 and 1. By default, this is set to 0.1. This option is ignored for standardization.}

\item{quant}{a boolean indicator to specify the type of stratification. If true (default), the model will stratify by
percentiles. If false, the scores will be grouped by a range of their raw values. This option is ignored for standardization.}

\item{...}{additional arguments that may be passed to the underlying \code{\link[=propensity_scores]{propensity_scores}} function.}
}
\value{
\code{propensity_matching} returns an object of \code{\link[base:class]{class} "propensity_matching"}

The functions \code{print}, \code{summary}, and \code{predict} can be used to interact with the underlying \code{glht} or
\code{standardization} model.

An object of class \code{"propensity_matching"} is a list containing the following:

 \item{call}{the matched call.}
 \item{formula}{the formula used in the model.}
 \item{model}{either the underlying \code{glht} or \code{standardization} model.}
 \item{p.scores}{the estimated propensity scores}
 \item{ATE}{a data frame containing the ATE, SE, and 95\% CI of the ATE. }
 \item{ATE.summary}{either a data frame containing the \code{glht} or \code{standardization} summary. }
}
\description{
`propensity_matching` uses either stratification or standardization to model an outcome
conditional on the propensity scores. In stratification, the model will break the propensity scores
into groups and output a \code{\link[multcomp:glht]{glht}} model based off a contrast matrix which
estimates the change in average causal effect within groups of propensity scores. In standardization,
the model will output a \code{\link[=standardization]{standardization}} model that conditions on the
propensity strata rather than the covariates. The model can also predict the expected outcome.
}
\examples{
library(causaldata)
library(multcomp)

data(nhefs)
nhefs.nmv <- nhefs[which(!is.na(nhefs$wt82)), ]
nhefs.nmv$qsmk <- as.factor(nhefs.nmv$qsmk)

confounders <- c(
  "sex", "race", "age", "education", "smokeintensity",
  "smokeyrs", "exercise", "active", "wt71"
)

init_params(wt82_71, qsmk,
  covariates = confounders,
  data = nhefs.nmv
)

pm.model <- propensity_matching(nhefs.nmv)
pm.model$ATE.summary
summary(pm.model)
head(data.frame(preds = predict(pm.model)))

}
