% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atom-search.R
\name{catr_atom_search_munic}
\alias{catr_atom_search_munic}
\title{ATOM INSPIRE: Search for municipality codes}
\usage{
catr_atom_search_munic(
  munic,
  to = NULL,
  cache = deprecated(),
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{munic}{Municipality to extract. It can be a part of a string or the
cadastral code. See \code{\link[=catr_atom_search_munic]{catr_atom_search_munic()}} for getting the cadastral
codes.}

\item{to}{Optional argument for defining the territorial office to which
\code{munic} belongs. This argument is a helper for narrowing the search.}

\item{cache}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{cache} is no longer
supported; this function will always cache results.}

\item{update_cache}{logical. Should the cached file be refreshed? Default is
\code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{A path to a cache directory. On \code{NULL} the function
would store the cached files on a temporary dir (See \code{\link[base:tempfile]{base::tempdir()}}).}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \link[tibble:tbl_df-class]{tibble}.
}
\description{
Search for a municipality (as a string, part of a string, or code) and get
the corresponding code as per the Cadastre.
}
\examples{
\dontshow{if (run_example()) withAutoprint(\{ # examplesIf}
\donttest{
catr_atom_search_munic("Mad")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other INSPIRE ATOM services:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_get_parcels_db_all}()}

Other search: 
\code{\link{catr_get_code_from_coords}()},
\code{\link{catr_ovc_get_cod_munic}()},
\code{\link{catr_ovc_get_cod_provinces}()}

Other databases: 
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_srs_values}}
}
\concept{ATOM}
\concept{databases}
\concept{search}
