% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_daily_PRM.R
\name{plot_daily_PRM}
\alias{plot_daily_PRM}
\title{Plot Daily Average PRM Values for a Single Site/Sampling Year}
\usage{
plot_daily_PRM(
  daily_PRM_data,
  wet_season_start = NULL,
  wet_season_length = 182,
  PRM_group = "Total PRM",
  title = FALSE,
  legend = "Numerical"
)
}
\arguments{
\item{daily_PRM_data}{A data set of calculated daily average PRM values for
a single site and sampling year. This data set should also include a "Date",
"Sampling Year" and "Site Name" column.}

\item{wet_season_start}{The date of the start of the wet season for this
site sampling year. If not applicable leave as NA}

\item{wet_season_length}{The length of the wet season in days.}

\item{PRM_group}{This specifies the name of the column to plot.
The daily average calculations gives PRM for each pesticide type and
a total in different columns. "Total" is set as
the default as it is the PRM value for all pesticides.}

\item{title}{TRUE or FALSE value to include a title.}

\item{legend}{Does the legend show "Numerical" or "Categorical" values for
PRM values on the plot.}
}
\value{
A plotly plot
}
\description{
Plot Daily Average PRM Values for a Single Site/Sampling Year
}
\examples{
Canto_pesticides_LOR_treated <- treat_LORs_all_data(raw_data = Canto_pesticides,
pesticide_info = CalcThemAll.PRM::pesticide_info)
Canto_daily_PRM <- calculate_daily_average_PRM(LOR_treated_data = Canto_pesticides_LOR_treated)
Violet_Town_2017_2018_PRM <- Canto_daily_PRM \%>\%
dplyr::filter(.data$`Sampling Year` ==  "2017-2018" &  .data$`Site Name` == "Violet Town")
plot_daily_PRM(Violet_Town_2017_2018_PRM, "2017-10-02", PRM_group = "Total PRM")

}
