% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_BindDim.R
\name{BindDim}
\alias{BindDim}
\title{Bind two arrays by a specified named dimension}
\usage{
BindDim(x, along)
}
\arguments{
\item{x}{A list of two or more arrays with named dimensions to be bound 
together.}

\item{along}{A character string indicating the name of the binding dimension.}
}
\value{
A single array combining the arrays in \code{x} along the specified
 dimension, with dimension names. The order of the dimensions will be the
 same as in the first array provided in the list.
}
\description{
This function combines the data inside two or more arrays with named
dimensions along the specified \code{along} dimension. It is a wrapper of the
abind() function from the abind package.
}
\examples{
array1 <- array(1:100, dim = c(time = 1, lon = 10, lat = 10))
array2 <- array(101:200, dim = c(lon = 10, lat = 10, time = 1))
# Bind arrays
array3 <- BindDim(x = list(array1, array2),
                 along = "time")
# Check new dimensions
dim(array3)

}
\seealso{
\link[abind]{abind}
}
\author{
Agudetse Roures Victoria, \email{victoria.agudetse@bsc.es}
}
