% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc_crossover.R
\docType{data}
\name{crossover}
\alias{crossover}
\title{Cross-over data}
\format{
A data frame with 33 rows and three columns.
\describe{
\item{treatment}{the type of treatment applied. The three treatments are
placebo, aspirin and a new drug}
\item{success}{whether the treatment was a success or not}
\item{patient}{the patient the treatment was applied to}
}
}
\source{
StatXact (2003)
}
\usage{
data(crossover)
}
\description{
A success or fail response variable with three treatments repeated over 11
patients.
}
\details{
In StatXact (2003), three treatment, three period cross-over clinical data
for 11 patients are given. This is a CMH design with t = 3, c = 2, and
b = 11.
}
\examples{
attach(crossover)
CMH(treatment = treatment,response = success,strata = patient)
}
\references{
StatXact (2003). User Manual Volume 2. CYTEL Software.
}
\keyword{crossover}
\keyword{datasets}
