% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata_cmgfm.R
\name{gendata_cmgfm}
\alias{gendata_cmgfm}
\title{Generate simulated data}
\usage{
gendata_cmgfm(
  seed = 1,
  n = 300,
  pveclist = list(gaussian = c(50, 150), poisson = c(50), binomial = c(100, 60)),
  q = 6,
  d = 3,
  rho = rep(1, length(pveclist)),
  rho_z = 1,
  sigmavec = rep(0.5, length(pveclist)),
  n_bin = 1,
  sigma_eps = 1,
  seed.para = 1
)
}
\arguments{
\item{seed}{a positive integer, the random seed for reproducibility of data generation process.}

\item{n}{a positive integer, specify the sample size.}

\item{pveclist}{a named list, specify the number of modalities for each variable type and dimension of variables in each modality.}

\item{q}{a positive integer,  specify the number of modality-shared factors.}

\item{d}{a positive integer,  specify the dimension of covariate matrix.}

\item{rho}{a numeric vector with length \code{length(pveclist)} and positive elements, specify the signal strength of loading matrix for each modality with the same variable type.}

\item{rho_z}{a positive real, specify the signal strength of covariates.}

\item{sigmavec}{a positive vector with length \code{length(pveclist)}, the variance of modality-specified latent factors.}

\item{n_bin}{a positive integer, specify the number of trails in Binomial distribution.}

\item{sigma_eps}{a positive real, the variance of overdispersion error.}

\item{seed.para}{a positive integer, the random seed for reproducibility of data generation process by fixing the regression coefficient vector and loading matrices.}
}
\value{
return a list including the following components:
\itemize{
  \item \code{XList} - a list consisting of multiple matrices in which each matrix has the same type of values, i.e., continuous, or count, or binomial/binary values.
  \item \code{Z} - a matrix, the fixed-dimensional covariate matrix with control variables;
  \item \code{Alist} - the the offset vector for each modality; 
  \item \code{B0list} - the true loading matrix for each modality; 
  \item \code{mu0} - the true intercept vector for each modality;
  \item \code{U0} - the  modality-specified factor vector;
  \item \code{F0} -  the  modality-shared factor matrix; 
  \item \code{Uplist} - the true intercept-loading matrix for each modality;
  \item \code{beta} - the true regression coefficient vector for each modality; 
  \item \code{sigma_eps} -  the standard deviation of error term;
  \item \code{numvarmat} - a length(types)-by-d matrix, the number of variables in modalities that belong to the same type.
}
}
\description{
Generate simulated data from covariate-augumented generalized factor model
}
\details{
None
}
\examples{
n <- 300; 
pveclist = list('gaussian'=c(50, 150),'poisson'=c(50),'binomial'=c(100,60))
d <- 20; q <- 6;
datlist <- gendata_cmgfm(n=n, pveclist=pveclist, q=q, d=d)
str(datlist)
}
\references{
None
}
\seealso{
\code{\link{CMGFM}}
}
