% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmgfm.R
\name{CMGFM}
\alias{CMGFM}
\title{Fit the CMGFM model}
\usage{
CMGFM(
  XList,
  Z,
  types,
  numvarmat,
  q = 15,
  Alist = NULL,
  init = c("LFM", "GFM", "random"),
  maxIter = 30,
  epsELBO = 1e-08,
  verbose = TRUE,
  add_IC_iter = FALSE,
  seed = 1
)
}
\arguments{
\item{XList}{a list consisting of multiple matrices in which each matrix has the same type of values, i.e., continuous, or count, or binomial/binary values.}

\item{Z}{a matrix, the fixed-dimensional covariate matrix with control variables.}

\item{types}{a string vector, specify the variable type in each matrix in \code{XList};}

\item{numvarmat}{a \code{length(types)}-by-d matrix, specify the number of variables in modalities that belong to the same type.}

\item{q}{an optional string, specify the number of factors; default as 15.}

\item{Alist}{an optional vector, the offset for each unit; default as full-zero vector.}

\item{init}{an optional character, specify the method in initialization.}

\item{maxIter}{the maximum iteration of the VEM algorithm. The default is 30.}

\item{epsELBO}{an optional positive value, tolerance of relative variation rate of the evidence lower bound value, default as '1e-8'.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{add_IC_iter}{a logical value, add the identifiability condition in iterative algorithm or add it after algorithm converges; default as FALSE.}

\item{seed}{an integer, set the random seed in initialization, default as 1;}
}
\value{
return a list including the following components:
\itemize{
  \item \code{betaf} - the estimated regression coefficient vector for each modality; 
  \item \code{Bf} - the estimated loading matrix for each modality; 
  \item \code{M} - the estimated modality-shared factor matrix; 
  \item \code{Xif} - the estimated modality-specified factor vector;
  \item \code{S} - the estimated covariance matrix of modality-shared latent factors;
  \item \code{Om} - the posterior variance of modality-specified latent factors;
  \item \code{muf} - the estimated intercept vector for each modality;
  \item \code{Sigmam} - the variance of modality-specified factors;
  \item \code{invLambdaf} - the inverse of the estimated variances of error for each modality.
  \item \code{ELBO} -  the ELBO value when algorithm stops;
  \item \code{ELBO_seq} - the sequence of ELBO values.
  \item \code{time_use} - the running time in model fitting;
}
}
\description{
Fit the covariate-augumented generalized factor model
}
\details{
None
}
\examples{
pveclist <- list('gaussian'=c(50, 150),'poisson'=c(50, 150),
   'binomial'=c(100,60))
q <- 6
sigmavec <- rep(1,3)
pvec <- unlist(pveclist)
datlist <- gendata_cmgfm(pveclist = pveclist, seed = 1, n = 300,d = 3,
                         q = q, rho = rep(1,length(pveclist)), rho_z=0.2,
                         sigmavec=sigmavec, sigma_eps=1)
XList <- datlist$XList
Z <- datlist$Z
numvarmat <- datlist$numvarmat
types <- datlist$types
rlist <- CMGFM(XList, Z, types=types, numvarmat, q=q)
str(rlist)

}
\references{
None
}
\seealso{
None
}
