% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_estimate_iptw_att_boot.R
\name{ce_estimate_iptw_att_boot}
\alias{ce_estimate_iptw_att_boot}
\title{Causal inference with multiple treatments using IPTW for ATT effects
(bootstrapping for CI)}
\usage{
ce_estimate_iptw_att_boot(
  y,
  x,
  w,
  reference_trt,
  method,
  nboots,
  verbose_boot,
  ...
)
}
\arguments{
\item{y}{A numeric vector (0, 1) representing a binary outcome.}

\item{x}{A dataframe, including all the covariates but not treatments.}

\item{w}{A numeric vector representing the treatment groups.}

\item{reference_trt}{A numeric value indicating reference treatment group
for ATT effect.}

\item{method}{A character string. Users can selected from the
following methods including \code{"IPTW-Multinomial"},
 \code{"IPTW-GBM"}, \code{"IPTW-SL"}.}

\item{nboots}{A numeric value representing the number of bootstrap samples.}

\item{verbose_boot}{A logical value indicating whether to print
the progress of nonparametric bootstrap. The default is \code{TRUE}.}

\item{...}{Other parameters that can be passed through to functions.}
}
\value{
A summary of the effect estimates can be obtained
with \code{summary} function.
}
\description{
The function \code{ce_estimate_iptw_att_boot} implements
IPTW with bootstrapping to estimate ATT effect with
multiple treatments using observational data.
}
\references{
Hadley Wickham (2019).
\emph{stringr: Simple, Consistent Wrappers for Common String Operations}.
R package version 1.4.0.
URL:\url{https://CRAN.R-project.org/package=stringr}
}
