% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata_prep.R
\name{cata_prep}
\alias{cata_prep}
\title{Prepare data for \code{\link[=cata_code]{cata_code()}}}
\usage{
cata_prep(
  data,
  id,
  cols,
  time = NULL,
  names_to = "Category",
  values_to = "Response",
  ...
)
}
\arguments{
\item{data}{A data frame where rows are participants or participant by time combinations if \code{time} is specified.}

\item{id}{The column in \code{data} to uniquely identify each participant.}

\item{cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> The columns in \code{data} indicating the check-all-that-apply categories to combine.
Endorsement of the category should be indicated by the same value (e.g., 1, "Yes") across all columns included here. Columns are
typically dichotomous variables with the two values indicating endorsement or not, but this is not a requirement.}

\item{time}{The column in \code{data} for the time variable; used to reshape longitudinal data with multiple observations for each \code{id}.}

\item{names_to}{Character. The name for the new column of category labels (i.e., names of the \code{cols} columns), which is passed to \code{\link[tidyr:pivot_longer]{pivot_longer()}}.}

\item{values_to}{Character. The name for the new column of responses (i.e., cell values in the \code{cols} columns), which is passed to \code{\link[tidyr:pivot_longer]{pivot_longer()}}.}

\item{...}{Optional additional arguments passed to \code{\link[tidyr:pivot_longer]{pivot_longer()}}.}
}
\value{
An object of the same type as \code{data} with one row for each \code{id} (by \code{time}, if specified) by response category combination.
}
\description{
A helper function to transform data into a longer format in preparation for use in \code{\link[=cata_code]{cata_code()}}.
}
\examples{
data(sources_race)
cata_prep(data = sources_race, id = ID, cols = Black:White, time = Wave)

}
