% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratum_ARM.R
\name{stratum_ARM}
\alias{stratum_ARM}
\title{Stratified Adaptive Randomization via Mahalanobis Distance}
\usage{
stratum_ARM(
  covariate,
  assignment,
  cont_var = c("C1"),
  cat_var = c("N1", "N2"),
  levels_list = list(C1 = 0:1),
  q = 0.75
)
}
\arguments{
\item{covariate}{a data frame. A row of the dataframe
corresponds to the covariate profile of a patient.}

\item{assignment}{a vector. If partial patients had been allocated
, please input their allocation. IF
all the patients are not be allocated, please input
'assignment = NA' directly.}

\item{cont_var}{name of continuous covariates}

\item{cat_var}{name of categorical covariates}

\item{levels_list}{levels of each categorical covariate}

\item{q}{the biased coin probability.
\eqn{q} should be larger than 1/2 and less than 1, default = 0.75}
}
\value{
An object of class "ARM" is a list containing the following components:
\item{assignment}{Allocation of patients.}
\item{sample_size}{The number of patients in treatment 1 and treatment 2 respectively.}
\item{Mahalanobis_Distance}{Mahalanobis distance between treatment groups 1 and 2.}
}
\description{
Update Strata for ARM
}
