// Generated by rstantools.  Do not edit by hand.

/*
    CARME is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CARME is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CARME.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_CARMM_COV_P_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_CARMM_COV_P");
    reader.add_event(149, 147, "end", "model_CARMM_COV_P");
    return reader;
}
template <bool propto, typename T0__, typename T1__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T3__, T4__>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi,
                    const T1__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& D_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T3__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 5;
        validate_non_negative_index("phit_D", "n", n);
        Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> phit_D(n);
        stan::math::initialize(phit_D, DUMMY_VAR__);
        stan::math::fill(phit_D, DUMMY_VAR__);
        current_statement_begin__ = 6;
        validate_non_negative_index("phit_W", "n", n);
        Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> phit_W(n);
        stan::math::initialize(phit_W, DUMMY_VAR__);
        stan::math::fill(phit_W, DUMMY_VAR__);
        current_statement_begin__ = 7;
        validate_non_negative_index("ldet_terms", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ldet_terms(n);
        stan::math::initialize(ldet_terms, DUMMY_VAR__);
        stan::math::fill(ldet_terms, DUMMY_VAR__);
        current_statement_begin__ = 9;
        stan::math::assign(phit_D, transpose(elt_multiply(phi, D_sparse)));
        current_statement_begin__ = 10;
        stan::math::assign(phit_W, rep_row_vector(0, n));
        current_statement_begin__ = 11;
        for (int i = 1; i <= W_n; ++i) {
            current_statement_begin__ = 12;
            stan::model::assign(phit_W, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(W_sparse, i, "W_sparse", 1), 1, "W_sparse", 2)), stan::model::nil_index_list()), 
                        (get_base1(phit_W, get_base1(get_base1(W_sparse, i, "W_sparse", 1), 1, "W_sparse", 2), "phit_W", 1) + get_base1(phi, get_base1(get_base1(W_sparse, i, "W_sparse", 1), 2, "W_sparse", 2), "phi", 1)), 
                        "assigning variable phit_W");
            current_statement_begin__ = 13;
            stan::model::assign(phit_W, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(W_sparse, i, "W_sparse", 1), 2, "W_sparse", 2)), stan::model::nil_index_list()), 
                        (get_base1(phit_W, get_base1(get_base1(W_sparse, i, "W_sparse", 1), 2, "W_sparse", 2), "phit_W", 1) + get_base1(phi, get_base1(get_base1(W_sparse, i, "W_sparse", 1), 1, "W_sparse", 2), "phi", 1)), 
                        "assigning variable phit_W");
        }
        current_statement_begin__ = 16;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 16;
            stan::model::assign(ldet_terms, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        log1m((alpha * get_base1(lambda, i, "lambda", 1))), 
                        "assigning variable ldet_terms");
        }
        current_statement_begin__ = 17;
        return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (sum(ldet_terms) - (multiply(phit_D, phi) - (alpha * multiply(phit_W, phi))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T3__, T4__>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi,
                    const T1__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& D_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    return sparse_car_lpdf<false>(phi,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__);
}
struct sparse_car_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T3__, T4__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi,
                    const T1__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& D_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) const {
        return sparse_car_lpdf(phi, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__);
    }
};
template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
corr_val(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
             const int& n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 20;
        int n_vec(0);
        (void) n_vec;  // dummy to suppress unused var warning
        stan::math::fill(n_vec, std::numeric_limits<int>::min());
        current_statement_begin__ = 21;
        local_scalar_t__ num(DUMMY_VAR__);
        (void) num;  // dummy to suppress unused var warning
        stan::math::initialize(num, DUMMY_VAR__);
        stan::math::fill(num, DUMMY_VAR__);
        current_statement_begin__ = 22;
        local_scalar_t__ den_1(DUMMY_VAR__);
        (void) den_1;  // dummy to suppress unused var warning
        stan::math::initialize(den_1, DUMMY_VAR__);
        stan::math::fill(den_1, DUMMY_VAR__);
        current_statement_begin__ = 23;
        local_scalar_t__ den_2(DUMMY_VAR__);
        (void) den_2;  // dummy to suppress unused var warning
        stan::math::initialize(den_2, DUMMY_VAR__);
        stan::math::fill(den_2, DUMMY_VAR__);
        current_statement_begin__ = 24;
        stan::math::assign(n_vec, n);
        current_statement_begin__ = 25;
        stan::math::assign(num, ((n_vec * sum(elt_multiply(x, y))) - (sum(x) * sum(y))));
        current_statement_begin__ = 26;
        stan::math::assign(den_1, stan::math::sqrt(((n_vec * sum(elt_multiply(x, x))) - pow(sum(x), 2))));
        current_statement_begin__ = 27;
        stan::math::assign(den_2, stan::math::sqrt(((n_vec * sum(elt_multiply(y, y))) - pow(sum(y), 2))));
        current_statement_begin__ = 28;
        return stan::math::promote_scalar<fun_return_scalar_t__>((num / (den_1 * den_2)));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct corr_val_functor__ {
    template <typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
             const int& n, std::ostream* pstream__) const {
        return corr_val(x, y, n, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_CARMM_COV_P
  : public stan::model::model_base_crtp<model_CARMM_COV_P> {
private:
        int n;
        int m;
        matrix_d H;
        matrix_d W;
        int W_n;
        int k;
        matrix_d X_cov;
        std::vector<int> y;
        vector_d log_offset;
        double mu_gamma;
        double mu_beta;
        double sigma_gamma;
        double sigma_beta;
        double tau_shape;
        double tau_rate;
        vector_d n_i;
        std::vector<std::vector<int> > W_sparse;
        vector_d D_sparse;
        vector_d lambda;
public:
    model_CARMM_COV_P(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_CARMM_COV_P(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_CARMM_COV_P_namespace::model_CARMM_COV_P";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 36;
            context__.validate_dims("data initialization", "m", "int", context__.to_vec());
            m = int(0);
            vals_i__ = context__.vals_i("m");
            pos__ = 0;
            m = vals_i__[pos__++];
            check_greater_or_equal(function__, "m", m, 0);
            current_statement_begin__ = 37;
            validate_non_negative_index("H", "m", m);
            validate_non_negative_index("H", "n", n);
            context__.validate_dims("data initialization", "H", "matrix_d", context__.to_vec(m,n));
            H = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(m, n);
            vals_r__ = context__.vals_r("H");
            pos__ = 0;
            size_t H_j_2_max__ = n;
            size_t H_j_1_max__ = m;
            for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                    H(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 40;
            validate_non_negative_index("W", "n", n);
            validate_non_negative_index("W", "n", n);
            context__.validate_dims("data initialization", "W", "matrix_d", context__.to_vec(n,n));
            W = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, n);
            vals_r__ = context__.vals_r("W");
            pos__ = 0;
            size_t W_j_2_max__ = n;
            size_t W_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < W_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < W_j_1_max__; ++j_1__) {
                    W(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            check_greater_or_equal(function__, "W", W, 0);
            check_less_or_equal(function__, "W", W, 1);
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "W_n", "int", context__.to_vec());
            W_n = int(0);
            vals_i__ = context__.vals_i("W_n");
            pos__ = 0;
            W_n = vals_i__[pos__++];
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);
            current_statement_begin__ = 45;
            validate_non_negative_index("X_cov", "n", n);
            validate_non_negative_index("X_cov", "k", k);
            context__.validate_dims("data initialization", "X_cov", "matrix_d", context__.to_vec(n,k));
            X_cov = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, k);
            vals_r__ = context__.vals_r("X_cov");
            pos__ = 0;
            size_t X_cov_j_2_max__ = k;
            size_t X_cov_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < X_cov_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_cov_j_1_max__; ++j_1__) {
                    X_cov(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 48;
            validate_non_negative_index("y", "m", m);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(m));
            y = std::vector<int>(m, int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = m;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            size_t y_i_0_max__ = m;
            for (size_t i_0__ = 0; i_0__ < y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y[i_0__]", y[i_0__], 0);
            }
            current_statement_begin__ = 51;
            validate_non_negative_index("log_offset", "m", m);
            context__.validate_dims("data initialization", "log_offset", "vector_d", context__.to_vec(m));
            log_offset = Eigen::Matrix<double, Eigen::Dynamic, 1>(m);
            vals_r__ = context__.vals_r("log_offset");
            pos__ = 0;
            size_t log_offset_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < log_offset_j_1_max__; ++j_1__) {
                log_offset(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 54;
            context__.validate_dims("data initialization", "mu_gamma", "double", context__.to_vec());
            mu_gamma = double(0);
            vals_r__ = context__.vals_r("mu_gamma");
            pos__ = 0;
            mu_gamma = vals_r__[pos__++];
            current_statement_begin__ = 55;
            context__.validate_dims("data initialization", "mu_beta", "double", context__.to_vec());
            mu_beta = double(0);
            vals_r__ = context__.vals_r("mu_beta");
            pos__ = 0;
            mu_beta = vals_r__[pos__++];
            current_statement_begin__ = 56;
            context__.validate_dims("data initialization", "sigma_gamma", "double", context__.to_vec());
            sigma_gamma = double(0);
            vals_r__ = context__.vals_r("sigma_gamma");
            pos__ = 0;
            sigma_gamma = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_gamma", sigma_gamma, 0);
            current_statement_begin__ = 57;
            context__.validate_dims("data initialization", "sigma_beta", "double", context__.to_vec());
            sigma_beta = double(0);
            vals_r__ = context__.vals_r("sigma_beta");
            pos__ = 0;
            sigma_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_beta", sigma_beta, 0);
            current_statement_begin__ = 58;
            context__.validate_dims("data initialization", "tau_shape", "double", context__.to_vec());
            tau_shape = double(0);
            vals_r__ = context__.vals_r("tau_shape");
            pos__ = 0;
            tau_shape = vals_r__[pos__++];
            check_greater_or_equal(function__, "tau_shape", tau_shape, 0);
            current_statement_begin__ = 59;
            context__.validate_dims("data initialization", "tau_rate", "double", context__.to_vec());
            tau_rate = double(0);
            vals_r__ = context__.vals_r("tau_rate");
            pos__ = 0;
            tau_rate = vals_r__[pos__++];
            check_greater_or_equal(function__, "tau_rate", tau_rate, 0);
            // initialize transformed data variables
            current_statement_begin__ = 64;
            validate_non_negative_index("n_i", "n", n);
            n_i = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            stan::math::fill(n_i, DUMMY_VAR__);
            current_statement_begin__ = 65;
            validate_non_negative_index("W_sparse", "W_n", W_n);
            validate_non_negative_index("W_sparse", "2", 2);
            W_sparse = std::vector<std::vector<int> >(W_n, std::vector<int>(2, int(0)));
            stan::math::fill(W_sparse, std::numeric_limits<int>::min());
            current_statement_begin__ = 66;
            validate_non_negative_index("D_sparse", "n", n);
            D_sparse = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            stan::math::fill(D_sparse, DUMMY_VAR__);
            current_statement_begin__ = 67;
            validate_non_negative_index("lambda", "n", n);
            lambda = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            stan::math::fill(lambda, DUMMY_VAR__);
            // execute transformed data statements
            {
            current_statement_begin__ = 70;
            int counter(0);
            (void) counter;  // dummy to suppress unused var warning
            stan::math::fill(counter, std::numeric_limits<int>::min());
            current_statement_begin__ = 71;
            stan::math::assign(counter, 1);
            current_statement_begin__ = 73;
            for (int i = 1; i <= (n - 1); ++i) {
                current_statement_begin__ = 74;
                for (int j = (i + 1); j <= n; ++j) {
                    current_statement_begin__ = 75;
                    if (as_bool(logical_eq(get_base1(W, i, j, "W", 1), 1))) {
                        current_statement_begin__ = 76;
                        stan::model::assign(W_sparse, 
                                    stan::model::cons_list(stan::model::index_uni(counter), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                    i, 
                                    "assigning variable W_sparse");
                        current_statement_begin__ = 77;
                        stan::model::assign(W_sparse, 
                                    stan::model::cons_list(stan::model::index_uni(counter), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                                    j, 
                                    "assigning variable W_sparse");
                        current_statement_begin__ = 78;
                        stan::math::assign(counter, (counter + 1));
                    }
                }
            }
            }
            current_statement_begin__ = 83;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 83;
                stan::model::assign(D_sparse, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            sum(get_base1(W, i, "W", 1)), 
                            "assigning variable D_sparse");
            }
            {
            current_statement_begin__ = 85;
            validate_non_negative_index("invsqrtD", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> invsqrtD(n);
            stan::math::initialize(invsqrtD, DUMMY_VAR__);
            stan::math::fill(invsqrtD, DUMMY_VAR__);
            current_statement_begin__ = 86;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 87;
                stan::model::assign(invsqrtD, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (1 / stan::math::sqrt(get_base1(D_sparse, i, "D_sparse", 1))), 
                            "assigning variable invsqrtD");
            }
            current_statement_begin__ = 89;
            stan::math::assign(lambda, eigenvalues_sym(quad_form(W, diag_matrix(invsqrtD))));
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 93;
            num_params_r__ += 1;
            current_statement_begin__ = 94;
            num_params_r__ += 1;
            current_statement_begin__ = 95;
            validate_non_negative_index("phi_unsc", "n", n);
            num_params_r__ += n;
            current_statement_begin__ = 98;
            num_params_r__ += 1;
            current_statement_begin__ = 99;
            validate_non_negative_index("beta", "k", k);
            num_params_r__ += k;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_CARMM_COV_P() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 93;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 94;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 95;
        if (!(context__.contains_r("phi_unsc")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi_unsc missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi_unsc");
        pos__ = 0U;
        validate_non_negative_index("phi_unsc", "n", n);
        context__.validate_dims("parameter initialization", "phi_unsc", "vector_d", context__.to_vec(n));
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi_unsc(n);
        size_t phi_unsc_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < phi_unsc_j_1_max__; ++j_1__) {
            phi_unsc(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(phi_unsc);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi_unsc: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 98;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "gamma", "double", context__.to_vec());
        double gamma(0);
        gamma = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 99;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "k", k);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(k));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(k);
        size_t beta_j_1_max__ = k;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 93;
            local_scalar_t__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_lub_constrain(0, 1, lp__);
            else
                alpha = in__.scalar_lub_constrain(0, 1);
            current_statement_begin__ = 94;
            local_scalar_t__ tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.scalar_lb_constrain(0, lp__);
            else
                tau = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 95;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi_unsc;
            (void) phi_unsc;  // dummy to suppress unused var warning
            if (jacobian__)
                phi_unsc = in__.vector_constrain(n, lp__);
            else
                phi_unsc = in__.vector_constrain(n);
            current_statement_begin__ = 98;
            local_scalar_t__ gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.scalar_constrain(lp__);
            else
                gamma = in__.scalar_constrain();
            current_statement_begin__ = 99;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(k, lp__);
            else
                beta = in__.vector_constrain(k);
            // transformed parameters
            current_statement_begin__ = 102;
            validate_non_negative_index("r_mm", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> r_mm(m);
            stan::math::initialize(r_mm, DUMMY_VAR__);
            stan::math::fill(r_mm, DUMMY_VAR__);
            current_statement_begin__ = 103;
            local_scalar_t__ invtausq;
            (void) invtausq;  // dummy to suppress unused var warning
            stan::math::initialize(invtausq, DUMMY_VAR__);
            stan::math::fill(invtausq, DUMMY_VAR__);
            current_statement_begin__ = 104;
            validate_non_negative_index("phi", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi(n);
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 106;
            stan::math::assign(invtausq, inv_sqrt(tau));
            current_statement_begin__ = 107;
            stan::math::assign(phi, multiply(invtausq, phi_unsc));
            current_statement_begin__ = 110;
            stan::math::assign(r_mm, multiply(H, add(add(gamma, multiply(X_cov, beta)), phi)));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 102;
            size_t r_mm_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < r_mm_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(r_mm(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: r_mm" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable r_mm: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 103;
            if (stan::math::is_uninitialized(invtausq)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: invtausq";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable invtausq: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "invtausq", invtausq, 0);
            current_statement_begin__ = 104;
            size_t phi_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(phi(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: phi" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable phi: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 113;
            lp_accum__.add(sparse_car_lpdf<propto__>(phi_unsc, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__));
            current_statement_begin__ = 114;
            lp_accum__.add(gamma_log<propto__>(tau, tau_shape, tau_rate));
            current_statement_begin__ = 115;
            lp_accum__.add(normal_log<propto__>(beta, mu_beta, sigma_beta));
            current_statement_begin__ = 116;
            lp_accum__.add(normal_log<propto__>(gamma, mu_gamma, sigma_gamma));
            current_statement_begin__ = 119;
            lp_accum__.add(poisson_log<propto__>(y, stan::math::exp(add(log_offset, r_mm))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("tau");
        names__.push_back("phi_unsc");
        names__.push_back("gamma");
        names__.push_back("beta");
        names__.push_back("r_mm");
        names__.push_back("invtausq");
        names__.push_back("phi");
        names__.push_back("yrep");
        names__.push_back("log_lik");
        names__.push_back("log_lik_rep");
        names__.push_back("sum_ll");
        names__.push_back("sum_ll_rep");
        names__.push_back("ppp");
        names__.push_back("l_RR");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_CARMM_COV_P_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double alpha = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(alpha);
        double tau = in__.scalar_lb_constrain(0);
        vars__.push_back(tau);
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi_unsc = in__.vector_constrain(n);
        size_t phi_unsc_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < phi_unsc_j_1_max__; ++j_1__) {
            vars__.push_back(phi_unsc(j_1__));
        }
        double gamma = in__.scalar_constrain();
        vars__.push_back(gamma);
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(k);
        size_t beta_j_1_max__ = k;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 102;
            validate_non_negative_index("r_mm", "m", m);
            Eigen::Matrix<double, Eigen::Dynamic, 1> r_mm(m);
            stan::math::initialize(r_mm, DUMMY_VAR__);
            stan::math::fill(r_mm, DUMMY_VAR__);
            current_statement_begin__ = 103;
            double invtausq;
            (void) invtausq;  // dummy to suppress unused var warning
            stan::math::initialize(invtausq, DUMMY_VAR__);
            stan::math::fill(invtausq, DUMMY_VAR__);
            current_statement_begin__ = 104;
            validate_non_negative_index("phi", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> phi(n);
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 106;
            stan::math::assign(invtausq, inv_sqrt(tau));
            current_statement_begin__ = 107;
            stan::math::assign(phi, multiply(invtausq, phi_unsc));
            current_statement_begin__ = 110;
            stan::math::assign(r_mm, multiply(H, add(add(gamma, multiply(X_cov, beta)), phi)));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 103;
            check_greater_or_equal(function__, "invtausq", invtausq, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t r_mm_j_1_max__ = m;
                for (size_t j_1__ = 0; j_1__ < r_mm_j_1_max__; ++j_1__) {
                    vars__.push_back(r_mm(j_1__));
                }
                vars__.push_back(invtausq);
                size_t phi_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                    vars__.push_back(phi(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 122;
            validate_non_negative_index("yrep", "m", m);
            std::vector<int> yrep(m, int(0));
            stan::math::fill(yrep, std::numeric_limits<int>::min());
            current_statement_begin__ = 123;
            validate_non_negative_index("log_lik", "m", m);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(m);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 124;
            validate_non_negative_index("log_lik_rep", "m", m);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik_rep(m);
            stan::math::initialize(log_lik_rep, DUMMY_VAR__);
            stan::math::fill(log_lik_rep, DUMMY_VAR__);
            current_statement_begin__ = 125;
            double sum_ll;
            (void) sum_ll;  // dummy to suppress unused var warning
            stan::math::initialize(sum_ll, DUMMY_VAR__);
            stan::math::fill(sum_ll, DUMMY_VAR__);
            current_statement_begin__ = 126;
            double sum_ll_rep;
            (void) sum_ll_rep;  // dummy to suppress unused var warning
            stan::math::initialize(sum_ll_rep, DUMMY_VAR__);
            stan::math::fill(sum_ll_rep, DUMMY_VAR__);
            current_statement_begin__ = 127;
            double ppp;
            (void) ppp;  // dummy to suppress unused var warning
            stan::math::initialize(ppp, DUMMY_VAR__);
            stan::math::fill(ppp, DUMMY_VAR__);
            current_statement_begin__ = 128;
            validate_non_negative_index("l_RR", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> l_RR(n);
            stan::math::initialize(l_RR, DUMMY_VAR__);
            stan::math::fill(l_RR, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 131;
            stan::math::assign(l_RR, add(add(gamma, multiply(X_cov, beta)), phi));
            current_statement_begin__ = 134;
            for (int i = 1; i <= m; ++i) {
                current_statement_begin__ = 136;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            poisson_log(get_base1(y, i, "y", 1), stan::math::exp((get_base1(r_mm, i, "r_mm", 1) + get_base1(log_offset, i, "log_offset", 1)))), 
                            "assigning variable log_lik");
                current_statement_begin__ = 138;
                stan::model::assign(yrep, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            poisson_rng(stan::math::exp((get_base1(r_mm, i, "r_mm", 1) + get_base1(log_offset, i, "log_offset", 1))), base_rng__), 
                            "assigning variable yrep");
                current_statement_begin__ = 140;
                stan::model::assign(log_lik_rep, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            poisson_log(get_base1(yrep, i, "yrep", 1), stan::math::exp((get_base1(r_mm, i, "r_mm", 1) + get_base1(log_offset, i, "log_offset", 1)))), 
                            "assigning variable log_lik_rep");
            }
            current_statement_begin__ = 143;
            stan::math::assign(sum_ll, sum(log_lik));
            current_statement_begin__ = 144;
            stan::math::assign(sum_ll_rep, sum(log_lik_rep));
            current_statement_begin__ = 146;
            stan::math::assign(ppp, (logical_gt(sum_ll, sum_ll_rep) ? 1 : 0 ));
            // validate, write generated quantities
            current_statement_begin__ = 122;
            size_t yrep_i_0_max__ = m;
            for (size_t i_0__ = 0; i_0__ < yrep_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "yrep[i_0__]", yrep[i_0__], 0);
            }
            size_t yrep_k_0_max__ = m;
            for (size_t k_0__ = 0; k_0__ < yrep_k_0_max__; ++k_0__) {
                vars__.push_back(yrep[k_0__]);
            }
            current_statement_begin__ = 123;
            size_t log_lik_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 124;
            size_t log_lik_rep_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < log_lik_rep_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik_rep(j_1__));
            }
            current_statement_begin__ = 125;
            vars__.push_back(sum_ll);
            current_statement_begin__ = 126;
            vars__.push_back(sum_ll_rep);
            current_statement_begin__ = 127;
            vars__.push_back(ppp);
            current_statement_begin__ = 128;
            size_t l_RR_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < l_RR_j_1_max__; ++j_1__) {
                vars__.push_back(l_RR(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_CARMM_COV_P";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        size_t phi_unsc_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < phi_unsc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_unsc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        size_t beta_j_1_max__ = k;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t r_mm_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < r_mm_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r_mm" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "invtausq";
            param_names__.push_back(param_name_stream__.str());
            size_t phi_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t yrep_k_0_max__ = m;
        for (size_t k_0__ = 0; k_0__ < yrep_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "yrep" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_rep_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < log_lik_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sum_ll";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sum_ll_rep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "ppp";
        param_names__.push_back(param_name_stream__.str());
        size_t l_RR_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < l_RR_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "l_RR" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        size_t phi_unsc_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < phi_unsc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_unsc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        size_t beta_j_1_max__ = k;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t r_mm_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < r_mm_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r_mm" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "invtausq";
            param_names__.push_back(param_name_stream__.str());
            size_t phi_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t yrep_k_0_max__ = m;
        for (size_t k_0__ = 0; k_0__ < yrep_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "yrep" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_rep_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < log_lik_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sum_ll";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sum_ll_rep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "ppp";
        param_names__.push_back(param_name_stream__.str());
        size_t l_RR_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < l_RR_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "l_RR" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_CARMM_COV_P_namespace::model_CARMM_COV_P stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
