% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_surround.R
\name{get_surround}
\alias{get_surround}
\title{Get surrounding elements of an element in a matrix.}
\usage{
get_surround(data, index, type = "all")
}
\arguments{
\item{data}{Matrix.}

\item{index}{Index position of element. Input as a vector of row then column positions.}

\item{type}{Takes values of "direct" and "all". "direct" returns only the elements directly in contact with the specified element, whereas "all" returns every surrounding element including diagonals. Defaults to "all".}
}
\description{
This function extracts all surrounding elements of a specified element in a matrix and returns the result as a vector.
}
\examples{
M = matrix(1:20,4,5)
get_surround(data = M, index = c(2,3))
}
\keyword{elements}
\keyword{matrix}
\keyword{surrounding}
\keyword{vector}

