% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_min_dists.R
\name{find_min_dists}
\alias{find_min_dists}
\title{For all points in matrix 1, return the distance to and index of the
nearest point in matrix 2.}
\usage{
find_min_dists(mOne, mTwo)
}
\arguments{
\item{mOne}{A numeric matrix where each row is a localization and each
column is a spatial axis.}

\item{mTwo}{A numeric matrix with the same number of columns as mOne.}
}
\description{
Find the shortest distance between each point in one data set and the points
in a second set.

This function determines the distance between every point in mOne and the
nearest point in mTwo.
}
\examples{
# Generate random data.
set.seed(10)

mOne <- as.matrix(data.frame(
x = rnorm(10),
y = rbinom(10, 100, 0.5),
z = runif(10)
))

mTwo <- as.matrix(data.frame(
x = rnorm(20),
y = rbinom(20, 100, 0.5),
z = runif(20)
))

# Find the minimum distance between each point in mOne and the points in
# mTwo.
find_min_dists(mOne, mTwo)

}
\author{
Zach Colburn
}
