% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgwt_main.R
\name{runSGCC}
\alias{runSGCC}
\title{Run SGCC weighted similarity analysis in Fourier domain}
\usage{
runSGCC(
  signal1,
  signal2,
  SG = NULL,
  eps = 1e-12,
  validate = TRUE,
  return_parts = TRUE,
  low_only = FALSE
)
}
\arguments{
\item{signal1}{Either a signal name (character) for SG object, or SGWT Forward result, or SGWT object}

\item{signal2}{Either a signal name (character) for SG object, or SGWT Forward result, or SGWT object}

\item{SG}{SGWT object (required if signal1/signal2 are signal names)}

\item{eps}{Small numeric for numerical stability (default: 1e-12)}

\item{validate}{Logical; if TRUE, check consistency (default: TRUE)}

\item{return_parts}{Logical; if TRUE, return detailed components (default: TRUE)}

\item{low_only}{Logical; if TRUE, compute only low-frequency similarity (default: FALSE)}
}
\value{
Similarity analysis results computed in Fourier domain
}
\description{
Calculate energy-normalized weighted similarity between two signals
using Fourier domain coefficients directly (no vertex domain reconstruction).
Excludes DC component and uses energy-based weighting consistent with Parseval's theorem.
}
\examples{
\donttest{
# Create example data and compute SGWT
data <- data.frame(x = runif(100), y = runif(100),
                  signal1 = rnorm(100), signal2 = rnorm(100))
SG <- initSGWT(data, signals = c("signal1", "signal2"))
SG <- runSpecGraph(SG, k = 15)
SG <- runSGWT(SG)

# Between two signals in same SGWT object
similarity <- runSGCC("signal1", "signal2", SG = SG)
print(similarity)

# Between two SGWT objects
data2 <- data.frame(x = runif(100), y = runif(100), signal = rnorm(100))
SG2 <- initSGWT(data2, signals = "signal")
SG2 <- runSpecGraph(SG2, k = 15)
SG2 <- runSGWT(SG2)

similarity2 <- runSGCC(SG, SG2)
print(similarity2)
}
}
