% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depbcomp.R
\name{depbcomp}
\alias{depbcomp}
\title{Power for Comparing Dependent Coefficients in Multiple Regression with Two or Three Predictors
Requires correlations between all variables as sample size. Means, sds, and alpha are option. Also computes Power(All)}
\usage{
depbcomp(
  data = NULL,
  y = NULL,
  x1 = NULL,
  x2 = NULL,
  x3 = NULL,
  x4 = NULL,
  x5 = NULL,
  numpred = NULL,
  comps = "abs"
)
}
\arguments{
\item{data}{name of data file}

\item{y}{dependent variable name}

\item{x1}{first predictor variable name}

\item{x2}{second predictor variable name}

\item{x3}{third predictor variable name}

\item{x4}{fourth predictor variable name}

\item{x5}{fifth predictor variable name}

\item{numpred}{number of predictors}

\item{comps}{Type of comparison, "abs" for absolute values or "raw" for raw coefficients}
}
\value{
Comparing Dependent Coefficients in Multiple Regression
}
\description{
Power for Comparing Dependent Coefficients in Multiple Regression with Two or Three Predictors
Requires correlations between all variables as sample size. Means, sds, and alpha are option. Also computes Power(All)
}
\examples{
depbcomp(data=testreg,y=y,x1=x1,x2=x2,x3=x3,x4=x4,x5=x5, numpred=5,comps="abs")
}
