% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_comp.R
\name{ForestComp}
\alias{ForestComp}
\title{ForestComp}
\usage{
ForestComp(
  data,
  site,
  plot,
  exp_factor,
  status,
  species,
  dbh,
  relative = "BA",
  units = "metric"
)
}
\arguments{
\item{data}{A dataframe or tibble. Each row must be an observation of an individual tree.}

\item{site}{Must be a character variable (column) in the provided dataframe or tibble. Describes the broader location or forest where the data were collected.}

\item{plot}{Must be a character variable (column) in the provided dataframe or tibble. Identifies the plot in which the individual tree was measured.}

\item{exp_factor}{Must be a numeric variable (column) in the provided dataframe or tibble. The expansion factor specifies the number of trees per hectare (or per acre) that a given plot tree represents.}

\item{status}{Must be a character variable (column) in the provided dataframe or tibble. Specifies whether the individual tree is alive (1) or dead (0).}

\item{species}{Must be a character variable (column) in the provided dataframe or tibble. Specifies the species of the individual tree.}

\item{dbh}{Must be a numeric variable (column) in the provided dataframe or tibble. Provides the diameter at breast height (DBH) of the individual tree in either centimeters or inches.}

\item{relative}{Not a variable (column) in the provided dataframe or tibble. Specifies whether forest composition should be measured as relative basal area or relative density. Must be set to either "BA" or "density". The default is set to "BA".}

\item{units}{Not a variable (column) in the provided dataframe or tibble. Specifies whether the dbh variable was measured using metric (centimeters) or imperial (inches) units. Must be set to either "metric" or "imperial". The default is set to "metric".}
}
\value{
A dataframe with the following columns:
\itemize{
\item site: as described above
\item plot: as described above
\item species: as described above
\item dominance: relative basal area (or relative density) in percent (\%)
}
}
\description{
Compiles forest composition at the plot level. Measured as relative basal area or relative density for live trees.
}
\examples{
ForestComp(data = for_demo_data,
           site = "Forest",
           plot = "Plot_id",
           exp_factor = "SPH",
           status = "Live",
           species = "SPP",
           dbh = "DBH_CM",
           relative = "BA",
           units = "metric")

}
