% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryFun.R
\name{summaryFun}
\alias{summaryFun}
\title{Create or update the .summary flag column}
\usage{
summaryFun(
  data = NULL,
  dontFilterThese = NULL,
  onlyFilterThese = NULL,
  removeFilterColumns = FALSE,
  filterClean = FALSE
)
}
\arguments{
\item{data}{A data frame or tibble. Occurrence records to use as input.}

\item{dontFilterThese}{A character vector of flag columns to be ignored in the creation or updating
of the .summary column. Cannot be specified with onlyFilterThese.}

\item{onlyFilterThese}{A character vector. The inverse of dontFilterThese, where columns identified
here will be filtered and no others. Cannot be specified with dontFilterThese.}

\item{removeFilterColumns}{Logical. If TRUE all columns starting with "." will be removed in the
output data. This only makes sense to use when filterClean = TRUE. Default = FALSE.}

\item{filterClean}{Logical. If TRUE, the data will be filtered to only those occurrence where .summary
= TRUE (i.e., completely clean according to the used flag columns). Default = FALSE.}
}
\value{
Returns a data frame or tibble of the input data but modified based on the above parameters.
}
\description{
Using all flag columns (column names starting with "."), this function either creates or updates
the .summary flag column which is FALSE when ANY of the flag columns are FALSE. Columns can be excluded
and removed after creating the .summary column. Additionally, the occurrence dataset
can be filtered to only those where .summary = TRUE at the end of the function.
}
\examples{
# Read in example data
data(beesFlagged)

# To only update the .summary column
beesFlagged_out <- summaryFun(
    data = beesFlagged,
    dontFilterThese = c(".gridSummary", ".lonFlag", ".latFlag", ".uncer_terms", ".unLicensed"),
    removeFilterColumns = FALSE,
    filterClean = FALSE)
  # View output
table(beesFlagged_out$.summary, useNA = "always")

# Now filter to only the clean data and remove the flag columns
beesFlagged_out <- summaryFun(
  data = BeeBDC::beesFlagged,
  dontFilterThese = c(".gridSummary", ".lonFlag", ".latFlag", ".uncer_terms", ".unLicensed"),
  removeFilterColumns = TRUE,
  filterClean = TRUE)
# View output
table(beesFlagged_out$.summary, useNA = "always")



}
