/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.EuclideanToInfiniteNormUnitBallTransform;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class EuclideanBallToRTransform
extends Transform.MultivariateTransform {
    public static final String NAME = "sphericalTransform2";
    public static final String DIMENSION = "dim";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("dim", false)};

        @Override
        public String getParserName() {
            return EuclideanBallToRTransform.NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = xMLObject.getIntegerAttribute(EuclideanBallToRTransform.DIMENSION);
            ArrayList<Transform.MultivariableTransform> arrayList = new ArrayList<Transform.MultivariableTransform>();
            for (int i = 0; i < n + 1; ++i) {
                arrayList.add(new EuclideanBallToRTransform(n));
            }
            return new Transform.MultivariateArray(arrayList);
        }

        @Override
        public String getParserDescription() {
            return "A spherical transform.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return Transform.MultivariateArray.class;
        }
    };

    public EuclideanBallToRTransform(int n) {
        super(n);
    }

    @Override
    protected double[] transform(double[] dArray) {
        assert (this.isInEuclideanUnitBall(dArray)) : "Initial vector is not in the Euclidean unit ball.";
        double[] dArray2 = new double[dArray.length];
        double d = Math.pow(1.0 - EuclideanToInfiniteNormUnitBallTransform.squaredNorm(dArray), -0.5);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    @Override
    protected double[] inverse(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = Math.pow(1.0 + EuclideanToInfiniteNormUnitBallTransform.squaredNorm(dArray), -0.5);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    private boolean isInEuclideanUnitBall(double[] dArray) {
        return EuclideanToInfiniteNormUnitBallTransform.squaredNorm(dArray) <= 1.0;
    }

    private boolean isInStrictEuclideanUnitBall(double[] dArray) {
        return EuclideanToInfiniteNormUnitBallTransform.squaredNorm(dArray) <= 1.0;
    }

    @Override
    public boolean isInInteriorDomain(double[] dArray) {
        return this.isInStrictEuclideanUnitBall(dArray);
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException("Not relevant.");
    }

    @Override
    public String getTransformName() {
        return "EuclideanBallToRTransform";
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected double getLogJacobian(double[] dArray) {
        return -0.5 * (double)(this.dim + 2) * Math.log(1.0 - EuclideanToInfiniteNormUnitBallTransform.squaredNorm(dArray));
    }

    @Override
    protected double[] getGradientLogJacobianInverse(double[] dArray) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        double[][] dArray2 = new double[this.dim][this.dim];
        double d = 1.0 + EuclideanToInfiniteNormUnitBallTransform.squaredNorm(dArray);
        double d2 = Math.pow(d, -1.5);
        for (int i = 0; i < this.dim; ++i) {
            dArray2[i][i] = (d - dArray[i] * dArray[i]) * d2;
            for (int j = i + 1; j < this.dim; ++j) {
                dArray2[i][j] = -dArray[i] * dArray[j] * d2;
                dArray2[j][i] = dArray2[i][j];
            }
        }
        return dArray2;
    }
}

