% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson.R
\name{bi.dist.poisson}
\alias{bi.dist.poisson}
\title{Poisson Distribution}
\usage{
bi.dist.poisson(
  rate,
  is_sparse = FALSE,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{rate}{A numeric vector representing the average number of events.}

\item{is_sparse}{(bool, optional): Indicates whether the `rate` parameter is sparse. If `True`, a specialized sparse sampling implementation is used, which can be more efficient for models with many zero-rate components (e.g., zero-inflated models). Defaults to `False`.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector used for shaping. When `sample=False` (model building), this is used with `.expand(shape)` to set the distribution's batch shape. When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Poisson distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Poisson distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The **Poisson distribution** models the probability of observing a given number of events $k$ occurring in a fixed interval
of time or space when these events happen independently and at a constant average rate \deqn{\lambda > 0 }.
It is widely used for modeling **count data**, such as the number of emails received per hour or mutations in a DNA strand per unit length.
Formally,
\deqn{
  K \sim \text{Poisson}(\lambda)
}
where \deqn{ \lambda } is both the **mean** and **variance** of the distribution.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.poisson(rate = c(0.2, 0.5, 0.8), sample = TRUE)
}
}
