% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_nomial_logits.R
\name{bi.dist.multinomial_logits}
\alias{bi.dist.multinomial_logits}
\title{Multinomial logit}
\usage{
bi.dist.multinomial_logits(
  logits,
  total_count = 1,
  total_count_max = py_none(),
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{logits}{A numeric vector, matrix, or array representing the logits for each outcome.}

\item{total_count}{A numeric vector, matrix, or array representing the total number of trials.}

\item{total_count_max}{(int, optional): An optional integer providing an upper bound on `total_count`. This is used for performance optimization with `lax.scan` when `total_count` is a dynamic JAX tracer, helping to avoid recompilation.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector, matrix, or array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector specifying the shape of the distribution.  Use a vector (e.g., `c(10)`) to define the shape.}

\item{event}{Integer specifying the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{Logical; If TRUE, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI MultinomialLogits distribution object (for model building).

   - When \code{sample=TRUE}, a JAX array of samples drawn from the MultinomialLogits distribution (for direct sampling).

   - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
A *multinomial logits* distribution refers to a categorical (or more generally multinomial)
distribution over \eqn{K} classes whose probabilities are given via the softmax of a vector of logits.
That is, given a vector of real-valued logits \eqn{\ell = (\ell_1, \dots, \ell_K)}, the class probabilities are:
\deqn{
  p_k = \frac{\exp(\ell_k)}{\sum_{j=1}^K \exp(\ell_j)}.
 }
Then a single draw from the distribution yields one of the \eqn{K} classes (or for a multinomial count version, counts over the classes) with those probabilities.#' @export
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.multinomial_logits(logits =  c(0.2, 0.3, 0.5), total_count = 10, sample = TRUE)
}
}
\seealso{
This is a wrapper of  \url{https://num.pyro.ai/en/stable/distributions.html#multinomiallogits}
}
