% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.ttest.OneSample}
\alias{BF10.ttest.OneSample}
\title{Bayes Factor for a One-Sample Bayesian t-Test}
\usage{
BF10.ttest.OneSample(
  tval,
  df,
  prior_analysis,
  location,
  scale,
  dff,
  alternative,
  ROPE = NULL
)
}
\arguments{
\item{tval}{Numeric scalar. Observed t-value from the one-sample t-test.}

\item{df}{Numeric scalar. Degrees of freedom of the t-test (must be >= 1).}

\item{prior_analysis}{Character string. Statistical model for the analysis prior under the alternative hypothesis.
Choices are:
\describe{
\item{"Normal"}{Normal distribution.}
\item{"Moment"}{Normal moment prior.}
\item{"t-distribution"}{Scaled t-distribution.}
}}

\item{location}{Numeric scalar. Location parameter for the analysis prior under the alternative hypothesis.}

\item{scale}{Numeric scalar. Scale parameter for the analysis prior under the alternative hypothesis (must be > 0).}

\item{dff}{Numeric scalar. Degrees of freedom for the t-distribution prior (only required if \code{prior_analysis = "t-distribution"}; must be > 0). Ignored otherwise.}

\item{alternative}{Character string. The direction of the alternative hypothesis. One of:
\describe{
\item{"!="}{Two-sided (difference from 0).}
\item{">"}{Right-sided (greater than 0).}
\item{"<"}{Left-sided (less than 0).}
}}

\item{ROPE}{Optional numeric vector. Specifies bounds for an interval null hypothesis. For:
\describe{
\item{Two-sided (\code{"two.sided"})}{Must be a numeric vector of length 2 with two distinct finite values.}
\item{Right-sided (\code{"greater"})}{Must be a numeric scalar > 0.}
\item{Left-sided (\code{"less"})}{Must be a numeric scalar < 0.}
}}
}
\value{
A list of class \code{BFvalue_t} containing:
\describe{
\item{type}{Character, indicating "One-sample t-test".}
\item{bf10}{Numeric, the Bayes factor (BF10).}
\item{tval}{Observed t-value.}
\item{df}{Degrees of freedom.}
\item{analysis_h1}{List with the analysis prior parameters: \code{prior_analysis}, \code{location}, \code{scale}, and optionally \code{dff}.}
\item{alternative}{Character, the direction of the alternative hypothesis.}
\item{ROPE}{Optional numeric vector of interval null bounds.}
\item{d}{Numeric, observed Cohen's d.}
\item{p.value}{Numeric, p.value.}
}
}
\description{
Computes the Bayes factor (BF10) for a one-sample t-test, comparing an observed t-value
against either a point null hypothesis or an interval null hypothesis.
}
\examples{
BF10.ttest.OneSample(
tval = 2,
df = 50,
prior_analysis = "t-distribution",
location = 0,
scale = 0.707,
dff = 1,
alternative = "two.sided")


}
