% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.props}
\alias{BF10.props}
\title{Bayes factor for a Bayesian test of two proportions}
\usage{
BF10.props(a0, b0, a1, b1, a2, b2, n1, n2, x1, x2)
}
\arguments{
\item{a0}{Alpha parameter of the beta distribution under the null hypothesis.}

\item{b0}{Beta parameter of the beta distribution under the null hypothesis.}

\item{a1}{Alpha parameter of the analysis beta prior distribution for group 1 under the alternative hypothesis.}

\item{b1}{Beta parameter of the analysis beta prior distribution for group 1 under the alternative hypothesis.}

\item{a2}{Alpha parameter of the analysis beta prior distribution for group 2 under the alternative hypothesis.}

\item{b2}{Beta parameter of the analysis beta prior distribution for group 2 under the alternative hypothesis.}

\item{n1}{Sample size for group 1.}

\item{n2}{Sample size for group 2.}

\item{x1}{Observed number of successes for group 1.}

\item{x2}{Observed number of successes for group 2.}
}
\value{
The Bayes factor (BF10) for comparing two proportions.
}
\description{
Calculate the Bayes factor (BF10) for comparing two proportions using a Bayesian framework.
}
\examples{
BF10.props(
  a0 = 2, b0 = 3,
  a1 = 2, b1 = 3,
  a2 = 2, b2 = 3,
  n1 = 50, n2 = 60,
  x1 = 25, x2 = 30
)

}
