% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes.mfsurv.R
\name{mfsurv.summary}
\alias{mfsurv.summary}
\title{mfsurv.summary()}
\usage{
mfsurv.summary(object, parameter = c("betas", "gammas", "lambda"))
}
\arguments{
\item{object}{an object of class \code{mfsurv}, the output of \code{\link{mfsurv}}.}

\item{parameter}{one of three parameters of the mfsurv output. Indicate either "betas", "gammas" or "lambda".}
}
\value{
list. Empirical mean, standard deviation and quantiles for each variable.
}
\description{
Returns a summary of a mfsurv object via \code{\link[coda]{summary.mcmc}}.
}
\examples{
set.seed(95)
bgl <- Buhaugetal_2009_JCR
bgl <- subset(bgl, coupx == 0)
bgl <- na.omit(bgl)
Y   <- bgl$Y
X   <- as.matrix(cbind(1, bgl[,1:7]))
C   <- bgl$C
Z1  <- matrix(1, nrow = nrow(bgl))
Y0  <- bgl$Y0
model1 <- mfsurv(Y ~ X | C ~ Z1, Y0 = Y0,
                N = 50,
                burn = 20,
                thin = 15,
                w = c(0.1, .1, .1),
                m = 5,
                form = "Weibull",
                na.action = 'na.omit')

mfsurv.summary(model1, "betas")
}
