// Generated by rstantools.  Do not edit by hand.

/*
    BayesGmed is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BayesGmed is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BayesGmed.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-1-g67504470
#include <stan/model/model_header.hpp>
namespace model_BY_BM_single_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 29, column 2 to column 22)",
                                                      " (in 'string', line 31, column 2 to column 21)",
                                                      " (in 'string', line 35, column 2 to column 34)",
                                                      " (in 'string', line 36, column 2 to column 27)",
                                                      " (in 'string', line 38, column 2 to column 36)",
                                                      " (in 'string', line 39, column 2 to column 29)",
                                                      " (in 'string', line 40, column 2 to column 29)",
                                                      " (in 'string', line 52, column 2 to column 12)",
                                                      " (in 'string', line 54, column 2 to column 23)",
                                                      " (in 'string', line 55, column 2 to column 23)",
                                                      " (in 'string', line 56, column 2 to column 23)",
                                                      " (in 'string', line 57, column 2 to column 23)",
                                                      " (in 'string', line 58, column 2 to column 14)",
                                                      " (in 'string', line 59, column 2 to column 16)",
                                                      " (in 'string', line 60, column 2 to column 16)",
                                                      " (in 'string', line 61, column 2 to column 17)",
                                                      " (in 'string', line 62, column 2 to column 17)",
                                                      " (in 'string', line 63, column 2 to column 20)",
                                                      " (in 'string', line 64, column 2 to column 20)",
                                                      " (in 'string', line 65, column 2 to column 20)",
                                                      " (in 'string', line 66, column 2 to column 20)",
                                                      " (in 'string', line 69, column 4 to column 40)",
                                                      " (in 'string', line 71, column 4 to column 53)",
                                                      " (in 'string', line 73, column 4 to column 61)",
                                                      " (in 'string', line 75, column 4 to column 84)",
                                                      " (in 'string', line 76, column 4 to column 75)",
                                                      " (in 'string', line 78, column 4 to column 84)",
                                                      " (in 'string', line 79, column 4 to column 75)",
                                                      " (in 'string', line 81, column 4 to column 60)",
                                                      " (in 'string', line 82, column 4 to column 60)",
                                                      " (in 'string', line 84, column 4 to column 60)",
                                                      " (in 'string', line 85, column 4 to column 60)",
                                                      " (in 'string', line 86, column 4 to column 35)",
                                                      " (in 'string', line 87, column 4 to column 41)",
                                                      " (in 'string', line 88, column 4 to column 41)",
                                                      " (in 'string', line 67, column 17 to line 89, column 3)",
                                                      " (in 'string', line 67, column 2 to line 89, column 3)",
                                                      " (in 'string', line 44, column 2 to column 44)",
                                                      " (in 'string', line 45, column 2 to column 43)",
                                                      " (in 'string', line 47, column 2 to column 46)",
                                                      " (in 'string', line 48, column 2 to column 61)",
                                                      " (in 'string', line 3, column 2 to column 17)",
                                                      " (in 'string', line 5, column 2 to column 17)",
                                                      " (in 'string', line 7, column 9 to column 10)",
                                                      " (in 'string', line 7, column 12 to column 13)",
                                                      " (in 'string', line 7, column 2 to column 17)",
                                                      " (in 'string', line 9, column 9 to column 10)",
                                                      " (in 'string', line 9, column 2 to column 14)",
                                                      " (in 'string', line 11, column 8 to column 9)",
                                                      " (in 'string', line 11, column 2 to column 34)",
                                                      " (in 'string', line 13, column 8 to column 9)",
                                                      " (in 'string', line 13, column 2 to column 34)",
                                                      " (in 'string', line 15, column 9 to column 14)",
                                                      " (in 'string', line 15, column 2 to column 27)",
                                                      " (in 'string', line 16, column 9 to column 14)",
                                                      " (in 'string', line 16, column 2 to column 27)",
                                                      " (in 'string', line 18, column 13 to column 18)",
                                                      " (in 'string', line 18, column 2 to column 28)",
                                                      " (in 'string', line 19, column 13 to column 18)",
                                                      " (in 'string', line 19, column 2 to column 28)",
                                                      " (in 'string', line 23, column 9 to column 10)",
                                                      " (in 'string', line 23, column 2 to column 46)",
                                                      " (in 'string', line 25, column 9 to column 10)",
                                                      " (in 'string', line 25, column 2 to column 30)",
                                                      " (in 'string', line 29, column 9 to column 14)",
                                                      " (in 'string', line 31, column 9 to column 14)",
                                                      " (in 'string', line 35, column 9 to column 10)",
                                                      " (in 'string', line 38, column 9 to column 10)",
                                                      " (in 'string', line 61, column 9 to column 10)",
                                                      " (in 'string', line 62, column 9 to column 10)",
                                                      " (in 'string', line 63, column 9 to column 10)",
                                                      " (in 'string', line 64, column 9 to column 10)",
                                                      " (in 'string', line 65, column 9 to column 10)",
                                                      " (in 'string', line 66, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_BY_BM_single final : public model_base_crtp<model_BY_BM_single> {
private:
  int N;
  int P;
  Eigen::Matrix<double, -1, -1> X;
  Eigen::Matrix<double, -1, 1> A;
  std::vector<int> M;
  std::vector<int> Y;
  Eigen::Matrix<double, -1, 1> location_y;
  Eigen::Matrix<double, -1, 1> location_m;
  Eigen::Matrix<double, -1, -1> scale_y;
  Eigen::Matrix<double, -1, -1> scale_m;
  Eigen::Matrix<double, -1, 1> boot_probs;
  Eigen::Matrix<double, -1, 1> Mv;
  int alpha_1dim__;
  int beta_1dim__;
 
public:
  ~model_BY_BM_single() { }
  
  inline std::string model_name() const final { return "model_BY_BM_single"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-1-g67504470", "stancflags = "};
  }
  
  
  model_BY_BM_single(stan::io::var_context& context__,
                     unsigned int random_seed__ = 0,
                     std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_BY_BM_single_namespace::model_BY_BM_single";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 42;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 42;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 42;
      current_statement__ = 42;
      check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 43;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec());
      P = std::numeric_limits<int>::min();
      
      current_statement__ = 43;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 43;
      current_statement__ = 43;
      check_greater_or_equal(function__, "P", P, 0);
      current_statement__ = 44;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 45;
      validate_non_negative_index("X", "P", P);
      current_statement__ = 46;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, P));
      X = Eigen::Matrix<double, -1, -1>(N, P);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 46;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 46;
        pos__ = 1;
        current_statement__ = 46;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 46;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 46;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 46;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 47;
      validate_non_negative_index("A", "N", N);
      current_statement__ = 48;
      context__.validate_dims("data initialization","A","double",
          context__.to_vec(N));
      A = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(A, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> A_flat__;
        current_statement__ = 48;
        assign(A_flat__, nil_index_list(), context__.vals_r("A"),
          "assigning variable A_flat__");
        current_statement__ = 48;
        pos__ = 1;
        current_statement__ = 48;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 48;
          assign(A, cons_list(index_uni(sym1__), nil_index_list()),
            A_flat__[(pos__ - 1)], "assigning variable A");
          current_statement__ = 48;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 49;
      validate_non_negative_index("M", "N", N);
      current_statement__ = 50;
      context__.validate_dims("data initialization","M","int",
          context__.to_vec(N));
      M = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 50;
      assign(M, nil_index_list(), context__.vals_i("M"),
        "assigning variable M");
      current_statement__ = 50;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 50;
        current_statement__ = 50;
        check_greater_or_equal(function__, "M[sym1__]", M[(sym1__ - 1)], 0);}
      current_statement__ = 50;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 50;
        current_statement__ = 50;
        check_less_or_equal(function__, "M[sym1__]", M[(sym1__ - 1)], 1);}
      current_statement__ = 51;
      validate_non_negative_index("Y", "N", N);
      current_statement__ = 52;
      context__.validate_dims("data initialization","Y","int",
          context__.to_vec(N));
      Y = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 52;
      assign(Y, nil_index_list(), context__.vals_i("Y"),
        "assigning variable Y");
      current_statement__ = 52;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 52;
        current_statement__ = 52;
        check_greater_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], 0);}
      current_statement__ = 52;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 52;
        current_statement__ = 52;
        check_less_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], 1);}
      current_statement__ = 53;
      validate_non_negative_index("location_y", "P + 2", (P + 2));
      current_statement__ = 54;
      context__.validate_dims("data initialization","location_y","double",
          context__.to_vec((P + 2)));
      location_y = Eigen::Matrix<double, -1, 1>((P + 2));
      stan::math::fill(location_y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> location_y_flat__;
        current_statement__ = 54;
        assign(location_y_flat__, nil_index_list(),
          context__.vals_r("location_y"),
          "assigning variable location_y_flat__");
        current_statement__ = 54;
        pos__ = 1;
        current_statement__ = 54;
        for (int sym1__ = 1; sym1__ <= (P + 2); ++sym1__) {
          current_statement__ = 54;
          assign(location_y, cons_list(index_uni(sym1__), nil_index_list()),
            location_y_flat__[(pos__ - 1)], "assigning variable location_y");
          current_statement__ = 54;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 55;
      validate_non_negative_index("location_m", "P + 1", (P + 1));
      current_statement__ = 56;
      context__.validate_dims("data initialization","location_m","double",
          context__.to_vec((P + 1)));
      location_m = Eigen::Matrix<double, -1, 1>((P + 1));
      stan::math::fill(location_m, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> location_m_flat__;
        current_statement__ = 56;
        assign(location_m_flat__, nil_index_list(),
          context__.vals_r("location_m"),
          "assigning variable location_m_flat__");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= (P + 1); ++sym1__) {
          current_statement__ = 56;
          assign(location_m, cons_list(index_uni(sym1__), nil_index_list()),
            location_m_flat__[(pos__ - 1)], "assigning variable location_m");
          current_statement__ = 56;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 57;
      validate_non_negative_index("scale_y", "P + 2", (P + 2));
      current_statement__ = 57;
      validate_non_negative_index("scale_y", "P + 2", (P + 2));
      current_statement__ = 58;
      context__.validate_dims("data initialization","scale_y","double",
          context__.to_vec((P + 2), (P + 2)));
      scale_y = Eigen::Matrix<double, -1, -1>((P + 2), (P + 2));
      stan::math::fill(scale_y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> scale_y_flat__;
        current_statement__ = 58;
        assign(scale_y_flat__, nil_index_list(), context__.vals_r("scale_y"),
          "assigning variable scale_y_flat__");
        current_statement__ = 58;
        pos__ = 1;
        current_statement__ = 58;
        for (int sym1__ = 1; sym1__ <= (P + 2); ++sym1__) {
          current_statement__ = 58;
          for (int sym2__ = 1; sym2__ <= (P + 2); ++sym2__) {
            current_statement__ = 58;
            assign(scale_y,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              scale_y_flat__[(pos__ - 1)], "assigning variable scale_y");
            current_statement__ = 58;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 58;
      current_statement__ = 58;
      check_cov_matrix(function__, "scale_y", scale_y);
      current_statement__ = 59;
      validate_non_negative_index("scale_m", "P + 1", (P + 1));
      current_statement__ = 59;
      validate_non_negative_index("scale_m", "P + 1", (P + 1));
      current_statement__ = 60;
      context__.validate_dims("data initialization","scale_m","double",
          context__.to_vec((P + 1), (P + 1)));
      scale_m = Eigen::Matrix<double, -1, -1>((P + 1), (P + 1));
      stan::math::fill(scale_m, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> scale_m_flat__;
        current_statement__ = 60;
        assign(scale_m_flat__, nil_index_list(), context__.vals_r("scale_m"),
          "assigning variable scale_m_flat__");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= (P + 1); ++sym1__) {
          current_statement__ = 60;
          for (int sym2__ = 1; sym2__ <= (P + 1); ++sym2__) {
            current_statement__ = 60;
            assign(scale_m,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              scale_m_flat__[(pos__ - 1)], "assigning variable scale_m");
            current_statement__ = 60;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 60;
      current_statement__ = 60;
      check_cov_matrix(function__, "scale_m", scale_m);
      current_statement__ = 61;
      validate_non_negative_index("boot_probs", "N", N);
      current_statement__ = 62;
      boot_probs = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(boot_probs, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 62;
      assign(boot_probs, nil_index_list(), rep_vector((1.0 / N), N),
        "assigning variable boot_probs");
      current_statement__ = 63;
      validate_non_negative_index("Mv", "N", N);
      current_statement__ = 64;
      Mv = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(Mv, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 64;
      assign(Mv, nil_index_list(), to_vector(M), "assigning variable Mv");
      current_statement__ = 65;
      alpha_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 65;
      alpha_1dim__ = (P + 2);
      current_statement__ = 65;
      validate_non_negative_index("alpha", "P + 2", alpha_1dim__);
      current_statement__ = 66;
      beta_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 66;
      beta_1dim__ = (P + 1);
      current_statement__ = 66;
      validate_non_negative_index("beta", "P + 1", beta_1dim__);
      current_statement__ = 67;
      validate_non_negative_index("betaZ", "P", P);
      current_statement__ = 68;
      validate_non_negative_index("alphaZ", "P", P);
      current_statement__ = 69;
      validate_non_negative_index("M_a0", "N", N);
      current_statement__ = 70;
      validate_non_negative_index("M_a1", "N", N);
      current_statement__ = 71;
      validate_non_negative_index("Y_a1Ma0", "N", N);
      current_statement__ = 72;
      validate_non_negative_index("Y_a0Ma0", "N", N);
      current_statement__ = 73;
      validate_non_negative_index("Y_a1Ma1", "N", N);
      current_statement__ = 74;
      validate_non_negative_index("Y_a0Ma1", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += alpha_1dim__;
      num_params_r__ += beta_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_BY_BM_single_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> alpha;
      alpha = Eigen::Matrix<local_scalar_t__, -1, 1>(alpha_1dim__);
      stan::math::fill(alpha, DUMMY_VAR__);
      
      current_statement__ = 1;
      alpha = in__.vector(alpha_1dim__);
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(beta_1dim__);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 2;
      beta = in__.vector(beta_1dim__);
      Eigen::Matrix<local_scalar_t__, -1, 1> betaZ;
      betaZ = Eigen::Matrix<local_scalar_t__, -1, 1>(P);
      stan::math::fill(betaZ, DUMMY_VAR__);
      
      current_statement__ = 3;
      assign(betaZ, nil_index_list(), head(beta, P),
        "assigning variable betaZ");
      local_scalar_t__ betaA;
      betaA = DUMMY_VAR__;
      
      current_statement__ = 4;
      betaA = beta[((P + 1) - 1)];
      Eigen::Matrix<local_scalar_t__, -1, 1> alphaZ;
      alphaZ = Eigen::Matrix<local_scalar_t__, -1, 1>(P);
      stan::math::fill(alphaZ, DUMMY_VAR__);
      
      current_statement__ = 5;
      assign(alphaZ, nil_index_list(), head(alpha, P),
        "assigning variable alphaZ");
      local_scalar_t__ alphaA;
      alphaA = DUMMY_VAR__;
      
      current_statement__ = 6;
      alphaA = alpha[((P + 1) - 1)];
      local_scalar_t__ alphaM;
      alphaM = DUMMY_VAR__;
      
      current_statement__ = 7;
      alphaM = alpha[((P + 2) - 1)];
      {
        current_statement__ = 38;
        lp_accum__.add(
          multi_normal_lpdf<propto__>(alpha, location_y, scale_y));
        current_statement__ = 39;
        lp_accum__.add(multi_normal_lpdf<propto__>(beta, location_m, scale_m));
        current_statement__ = 40;
        lp_accum__.add(
          bernoulli_logit_lpmf<propto__>(M,
            add(multiply(X, betaZ), multiply(A, betaA))));
        current_statement__ = 41;
        lp_accum__.add(
          bernoulli_logit_lpmf<propto__>(Y,
            add(add(multiply(X, alphaZ), multiply(A, alphaA)),
              multiply(Mv, alphaM))));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_BY_BM_single_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(alpha_1dim__);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      alpha = in__.vector(alpha_1dim__);
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(beta_1dim__);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      beta = in__.vector(beta_1dim__);
      Eigen::Matrix<double, -1, 1> betaZ;
      betaZ = Eigen::Matrix<double, -1, 1>(P);
      stan::math::fill(betaZ, std::numeric_limits<double>::quiet_NaN());
      
      double betaA;
      betaA = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> alphaZ;
      alphaZ = Eigen::Matrix<double, -1, 1>(P);
      stan::math::fill(alphaZ, std::numeric_limits<double>::quiet_NaN());
      
      double alphaA;
      alphaA = std::numeric_limits<double>::quiet_NaN();
      
      double alphaM;
      alphaM = std::numeric_limits<double>::quiet_NaN();
      
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 3;
      assign(betaZ, nil_index_list(), head(beta, P),
        "assigning variable betaZ");
      current_statement__ = 4;
      betaA = beta[((P + 1) - 1)];
      current_statement__ = 5;
      assign(alphaZ, nil_index_list(), head(alpha, P),
        "assigning variable alphaZ");
      current_statement__ = 6;
      alphaA = alpha[((P + 1) - 1)];
      current_statement__ = 7;
      alphaM = alpha[((P + 2) - 1)];
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          vars__.emplace_back(betaZ[(sym1__ - 1)]);}
        vars__.emplace_back(betaA);
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          vars__.emplace_back(alphaZ[(sym1__ - 1)]);}
        vars__.emplace_back(alphaA);
        vars__.emplace_back(alphaM);
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      int row_i;
      row_i = std::numeric_limits<int>::min();
      
      double NDE_control;
      NDE_control = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      NDE_control = 0;
      double NDE_treated;
      NDE_treated = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      NDE_treated = 0;
      double NIE_control;
      NIE_control = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      NIE_control = 0;
      double NIE_treated;
      NIE_treated = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      NIE_treated = 0;
      double TE;
      TE = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      TE = 0;
      double ANDE;
      ANDE = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 14;
      ANDE = 0;
      double ANIE;
      ANIE = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 15;
      ANIE = 0;
      Eigen::Matrix<double, -1, 1> M_a0;
      M_a0 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(M_a0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> M_a1;
      M_a1 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(M_a1, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> Y_a1Ma0;
      Y_a1Ma0 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(Y_a1Ma0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> Y_a0Ma0;
      Y_a0Ma0 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(Y_a0Ma0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> Y_a1Ma1;
      Y_a1Ma1 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(Y_a1Ma1, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> Y_a0Ma1;
      Y_a0Ma1 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(Y_a0Ma1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 37;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 22;
        row_i = categorical_rng(boot_probs, base_rng__);
        current_statement__ = 23;
        assign(M_a0, cons_list(index_uni(n), nil_index_list()),
          bernoulli_logit_rng(
            multiply(
              rvalue(X, cons_list(index_uni(row_i), nil_index_list()), "X"),
              betaZ), base_rng__), "assigning variable M_a0");
        current_statement__ = 24;
        assign(M_a1, cons_list(index_uni(n), nil_index_list()),
          bernoulli_logit_rng(
            (multiply(
               rvalue(X, cons_list(index_uni(row_i), nil_index_list()), "X"),
               betaZ) + betaA), base_rng__), "assigning variable M_a1");
        current_statement__ = 25;
        assign(Y_a1Ma0, cons_list(index_uni(n), nil_index_list()),
          bernoulli_logit_rng(
            ((multiply(
                rvalue(X, cons_list(index_uni(row_i), nil_index_list()), "X"),
                alphaZ) + (M_a0[(n - 1)] * alphaM)) + alphaA), base_rng__),
          "assigning variable Y_a1Ma0");
        current_statement__ = 26;
        assign(Y_a0Ma0, cons_list(index_uni(n), nil_index_list()),
          bernoulli_logit_rng(
            (multiply(
               rvalue(X, cons_list(index_uni(row_i), nil_index_list()), "X"),
               alphaZ) + (M_a0[(n - 1)] * alphaM)), base_rng__),
          "assigning variable Y_a0Ma0");
        current_statement__ = 27;
        assign(Y_a1Ma1, cons_list(index_uni(n), nil_index_list()),
          bernoulli_logit_rng(
            ((multiply(
                rvalue(X, cons_list(index_uni(row_i), nil_index_list()), "X"),
                alphaZ) + (M_a1[(n - 1)] * alphaM)) + alphaA), base_rng__),
          "assigning variable Y_a1Ma1");
        current_statement__ = 28;
        assign(Y_a0Ma1, cons_list(index_uni(n), nil_index_list()),
          bernoulli_logit_rng(
            (multiply(
               rvalue(X, cons_list(index_uni(row_i), nil_index_list()), "X"),
               alphaZ) + (M_a1[(n - 1)] * alphaM)), base_rng__),
          "assigning variable Y_a0Ma1");
        current_statement__ = 29;
        NDE_control = (NDE_control +
                        ((Y_a1Ma0[(n - 1)] - Y_a0Ma0[(n - 1)]) / N));
        current_statement__ = 30;
        NDE_treated = (NDE_treated +
                        ((Y_a1Ma1[(n - 1)] - Y_a0Ma1[(n - 1)]) / N));
        current_statement__ = 31;
        NIE_treated = (NIE_treated +
                        ((Y_a1Ma1[(n - 1)] - Y_a1Ma0[(n - 1)]) / N));
        current_statement__ = 32;
        NIE_control = (NIE_control +
                        ((Y_a0Ma1[(n - 1)] - Y_a0Ma0[(n - 1)]) / N));
        current_statement__ = 33;
        TE = (NDE_control + NIE_treated);
        current_statement__ = 34;
        ANDE = ((NDE_control + NDE_treated) / 2);
        current_statement__ = 35;
        ANIE = ((NIE_control + NIE_treated) / 2);}
      vars__.emplace_back(row_i);
      vars__.emplace_back(NDE_control);
      vars__.emplace_back(NDE_treated);
      vars__.emplace_back(NIE_control);
      vars__.emplace_back(NIE_treated);
      vars__.emplace_back(TE);
      vars__.emplace_back(ANDE);
      vars__.emplace_back(ANIE);
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(M_a0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(M_a1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(Y_a1Ma0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(Y_a0Ma0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(Y_a1Ma1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(Y_a0Ma1[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(alpha_1dim__);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 1;
        assign(alpha_flat__, nil_index_list(), context__.vals_r("alpha"),
          "assigning variable alpha_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
          current_statement__ = 1;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            alpha_flat__[(pos__ - 1)], "assigning variable alpha");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(beta_1dim__);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 2;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
          current_statement__ = 2;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("alpha");
    names__.emplace_back("beta");
    names__.emplace_back("betaZ");
    names__.emplace_back("betaA");
    names__.emplace_back("alphaZ");
    names__.emplace_back("alphaA");
    names__.emplace_back("alphaM");
    names__.emplace_back("row_i");
    names__.emplace_back("NDE_control");
    names__.emplace_back("NDE_treated");
    names__.emplace_back("NIE_control");
    names__.emplace_back("NIE_treated");
    names__.emplace_back("TE");
    names__.emplace_back("ANDE");
    names__.emplace_back("ANIE");
    names__.emplace_back("M_a0");
    names__.emplace_back("M_a1");
    names__.emplace_back("Y_a1Ma0");
    names__.emplace_back("Y_a0Ma0");
    names__.emplace_back("Y_a1Ma1");
    names__.emplace_back("Y_a0Ma1");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(alpha_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(beta_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "betaZ" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "betaA");
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "alphaZ" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "alphaA");
      param_names__.emplace_back(std::string() + "alphaM");
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "row_i");
      param_names__.emplace_back(std::string() + "NDE_control");
      param_names__.emplace_back(std::string() + "NDE_treated");
      param_names__.emplace_back(std::string() + "NIE_control");
      param_names__.emplace_back(std::string() + "NIE_treated");
      param_names__.emplace_back(std::string() + "TE");
      param_names__.emplace_back(std::string() + "ANDE");
      param_names__.emplace_back(std::string() + "ANIE");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "M_a0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "M_a1" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Y_a1Ma0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Y_a0Ma0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Y_a1Ma1" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Y_a0Ma1" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "betaZ" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "betaA");
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "alphaZ" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "alphaA");
      param_names__.emplace_back(std::string() + "alphaM");
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "row_i");
      param_names__.emplace_back(std::string() + "NDE_control");
      param_names__.emplace_back(std::string() + "NDE_treated");
      param_names__.emplace_back(std::string() + "NIE_control");
      param_names__.emplace_back(std::string() + "NIE_treated");
      param_names__.emplace_back(std::string() + "TE");
      param_names__.emplace_back(std::string() + "ANDE");
      param_names__.emplace_back(std::string() + "ANIE");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "M_a0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "M_a1" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Y_a1Ma0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Y_a0Ma0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Y_a1Ma1" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Y_a0Ma1" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << alpha_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << beta_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"betaZ\",\"type\":{\"name\":\"vector\",\"length\":" << P << "},\"block\":\"transformed_parameters\"},{\"name\":\"betaA\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"alphaZ\",\"type\":{\"name\":\"vector\",\"length\":" << P << "},\"block\":\"transformed_parameters\"},{\"name\":\"alphaA\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"alphaM\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"row_i\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"NDE_control\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"NDE_treated\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"NIE_control\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"NIE_treated\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"TE\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"ANDE\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"ANIE\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"M_a0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"M_a1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"Y_a1Ma0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"Y_a0Ma0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"Y_a1Ma1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"Y_a0Ma1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << alpha_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << beta_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"betaZ\",\"type\":{\"name\":\"vector\",\"length\":" << P << "},\"block\":\"transformed_parameters\"},{\"name\":\"betaA\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"alphaZ\",\"type\":{\"name\":\"vector\",\"length\":" << P << "},\"block\":\"transformed_parameters\"},{\"name\":\"alphaA\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"alphaM\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"row_i\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"NDE_control\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"NDE_treated\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"NIE_control\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"NIE_treated\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"TE\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"ANDE\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"ANIE\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"M_a0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"M_a1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"Y_a1Ma0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"Y_a0Ma0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"Y_a1Ma1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"Y_a0Ma1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_BY_BM_single_namespace::model_BY_BM_single;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_BY_BM_single_namespace::profiles__;
}
#endif
#endif
