% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_model_fit.R
\name{model_fit}
\alias{model_fit}
\title{Model fitting with random effects/fixed effects}
\usage{
model_fit(
  formula,
  data,
  method = "aghq",
  family = "gaussian",
  control.family,
  control.fixed,
  aghq_k = 4,
  size = NULL,
  cens = NULL,
  weight = NULL,
  strata = NULL,
  M = 3000,
  customized_template = NULL,
  Customized_RE = NULL,
  option_list = list(),
  envir = parent.frame(),
  extra_theta_num = NULL
)
}
\arguments{
\item{formula}{A formula that contains one response variable, and covariates with either random or fixed effect.}

\item{data}{A dataframe that contains the response variable and other covariates mentioned in the formula.}

\item{method}{The inference method used in the model. By default, the method is set to be "aghq".}

\item{family}{The family of response used in the model. By default, the family is set to be "gaussian".}

\item{control.family}{Parameters used to specify the priors for the family parameters, such as the standard deviation parameter of Gaussian family. For example control.family = 1 in the Gaussian family corresponds to an Exponential prior to the standard deviation parameter of the Gaussian noise with median 1. When left unspecified, the default prior is an Exponential prior with median 1.}

\item{control.fixed}{Parameters used to specify the priors for the fixed effects. For example control.fixed = list(intercept = list(prec = 0.001, mean = 0)) will setup the prior N(0,1/0.001) for the intercept parameter. When left unspecified, all fixed effect parameters will be assigned independent N(0,1/0.001) priors.}

\item{aghq_k}{An integer to specify the number of quadrature points used in the aghq method. By default, the value is 4.}

\item{size}{The name of the size variable, should be one of the variables in `data`. The default value is "NULL", corresponding to a vector of 1s. This is only used for the Binomial family, and denotes the number of binomial trails.}

\item{cens}{The name of the right-censoring indicator, should be one of the variables in `data`. The default value is "NULL". This is only used for the CoxPH family.}

\item{weight}{The name of the weight variable, should be one of the variables in `data`. The default value is "NULL", corresponding to a vector of 1s. This is only used for the Case-Crossover family, and denotes the weight of each observation.}

\item{strata}{The name of the strata variable, should be one of the variables in `data`. The default value is "NULL". This is only used for the Case-Crossover family, and denotes the strata of each observation.}

\item{M}{The number of posterior samples to be taken, by default is 3000.}

\item{customized_template}{The name of the customized cpp template that the user wants to use instead. By default this is NULL, and the cpp template `BayesGP` will be used.}

\item{Customized_RE}{The list that contains the compute_B and compute_P functions for the customized random effect. By default, this is NULL and there is not customized random effect in the model.}

\item{option_list}{A list that controls the details of the inference algorithm, by default is an empty list.}

\item{envir}{The environment in which the formula and other expressions are to be evaluated. 
Defaults to `parent.frame()`, which refers to the environment from which the function was called.
This allows the function to access variables that are defined in the calling function's scope.}

\item{extra_theta_num}{An integer number to indicate the extra number of parameters required in the 'theta' vector. Should only be specified when using customized template.}
}
\value{
A list that contains following items: the S4 objects for the random effects (instances), concatenated design matrix for
the fixed effects (design_mat_fixed), fitted aghq (mod) and indexes to partition the posterior samples
(boundary_samp_indexes, random_samp_indexes and fixed_samp_indexes).
}
\description{
Fitting a hierarchical model based on the provided formula, data and parameters such as type of method and family of response.
Returning the S4 objects for the random effects, concatenated design matrix for the intercepts and fixed effects, fitted model,
indexes to partition the posterior samples.
}
