% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localPP.R
\name{localPP}
\alias{localPP}
\title{Local Power Prior for Bayesian Basket Trial}
\usage{
localPP(
  nDat,
  yDat,
  be.a0 = NULL,
  be.b0 = NULL,
  a = 1,
  delta = 0.4,
  method = "PEB",
  symmetry = FALSE
)
}
\arguments{
\item{nDat}{a vector of length B for the sample size in each basket.}

\item{yDat}{a vector of length B for the number of responses in each basket.}

\item{be.a0}{a vector of length B for beta prior parameter a0 in each basket.}

\item{be.b0}{a vector of length B for beta prior parameter b0 in each basket.}

\item{a}{the global control parameter in the local PP 3-component framework.}

\item{delta}{the threshold parameter in the local PP 3-component framework.}

\item{method}{either \code{PEB} for the pairwise empirical Bayes or \code{GEB}
for the global empirical Bayes.}

\item{symmetry}{logical variable to indicate whether the similarity matrix
will be set to be symmetric; default is \code{FALSE}.}
}
\value{
It returns a list including the posterior beta parameters and similarity matrix.
}
\description{
Local Power Prior for Bayesian Basket Trial
}
\examples{
localPP(nDat = c(25, 25, 25, 25, 25), yDat = c(2,9,11,13,20),
be.a0 = rep(0.5, 5), be.b0 = rep(0.5, 5), a = 4, delta = 1, method = "PEB")
}
\references{
Zhou, H., Shen, R., Wu, S., & He, P. (2023). A Bayesian Basket Trial Design Using Local Power Prior.
arXiv preprint arXiv:2312.15352.
}
